/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.session.ServerProxyAcceptor;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaProxyProtocolAcceptor
implements ServerProxyAcceptor {
    public static final AttributeRepository.AttributeKey<SocketAddress> ATTRIBUTE_PROXIED_ADDRESS = new AttributeRepository.AttributeKey<SocketAddress>(){

        public String toString() {
            return "ATTRIBUTE_PROXIED_ADDRESS";
        }
    };
    private static final int EXPECTED_PROXY_HEADER_FIELDS = 6;
    private static final int MAX_PROXY_HEADER_LENGTH = 108;
    private static final byte[] PROXY_HEADER = new byte[]{80, 82, 79, 88, 89, 32};
    private static final Logger log = LoggerFactory.getLogger(HaProxyProtocolAcceptor.class);

    @Override
    public boolean acceptServerProxyMetadata(ServerSession serverSession, Buffer buffer) {
        int startingPosition = buffer.rpos();
        int dataLen = buffer.available();
        if (dataLen < PROXY_HEADER.length) {
            return false;
        }
        StringBuilder payload = new StringBuilder(108);
        Supplier<Character> next = () -> Character.valueOf((char)buffer.getUByte());
        while (payload.length() != PROXY_HEADER.length && buffer.available() > 0) {
            payload.append(next.get());
        }
        if (!Arrays.equals(payload.toString().getBytes(), PROXY_HEADER)) {
            buffer.rpos(startingPosition);
            return true;
        }
        while (payload.length() < 108 && buffer.available() > 0) {
            char curr = next.get().charValue();
            if (curr != '\r' && curr != '\n') {
                payload.append(curr);
                continue;
            }
            if (curr != '\n') continue;
            return this.parseProxyHeader(serverSession, payload.toString());
        }
        buffer.rpos(startingPosition);
        return false;
    }

    @VisibleForTesting
    boolean parseProxyHeader(ServerSession serverSession, String headerPayload) {
        String[] fields = StringUtils.split((String)headerPayload);
        if (fields.length != 6) {
            return true;
        }
        String protocol = fields[1].toUpperCase(Locale.ROOT);
        if (EnumUtils.isValidEnum(Protocol.class, (String)protocol)) {
            String srcAddr = fields[2];
            int srcPort = Integer.parseInt(fields[4]);
            InetSocketAddress proxiedAddress = new InetSocketAddress(srcAddr, srcPort);
            serverSession.setAttribute(ATTRIBUTE_PROXIED_ADDRESS, proxiedAddress);
            if (log.isTraceEnabled()) {
                log.trace("Received valid PROXY header '{}' - setting proxied address to {}", (Object)headerPayload, (Object)proxiedAddress);
            }
        }
        return true;
    }

    private static enum Protocol {
        TCP4,
        TCP6;

    }
}

