/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighLoadLogger {
    private final AtomicLong activeOperationsCounter;
    private final String highLoadMessage;
    private final int highLoadThreshold;
    private final RateLimiter logRateLimiter;
    private final Logger log = LoggerFactory.getLogger(HighLoadLogger.class);

    public HighLoadLogger(int highLoadThreshold, String highLoadMessage, int logsPerMinute) {
        this.activeOperationsCounter = new AtomicLong();
        this.highLoadThreshold = highLoadThreshold;
        this.highLoadMessage = highLoadMessage;
        this.logRateLimiter = RateLimiter.create((double)((double)logsPerMinute / 60.0));
    }

    @VisibleForTesting
    HighLoadLogger(int highLoadThreshold, String highLoadMessage, RateLimiter rateLimiter) {
        this.activeOperationsCounter = new AtomicLong();
        this.highLoadThreshold = highLoadThreshold;
        this.highLoadMessage = highLoadMessage;
        this.logRateLimiter = rateLimiter;
    }

    public void enter() {
        long activeOperations = this.activeOperationsCounter.incrementAndGet();
        if (this.isUnderHighLoad() && this.logRateLimiter.tryAcquire()) {
            this.log.info("{}. {} requests in progress", (Object)this.highLoadMessage, (Object)activeOperations);
        }
    }

    public void exit() {
        this.activeOperationsCounter.decrementAndGet();
    }

    public boolean isUnderHighLoad() {
        return this.activeOperationsCounter.get() > (long)this.highLoadThreshold;
    }
}

