/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.dmz.mirror.DmzSecretService;
import com.atlassian.bitbucket.internal.ssh.server.DefaultHostKeyPairProvider;
import com.atlassian.bitbucket.internal.ssh.server.HostKeyPairProvider;
import com.atlassian.bitbucket.internal.ssh.server.MirrorHostKeyPairProvider;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.plugin.event.PluginEventManager;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class HostKeyPairProviderFactory
extends AbstractFactoryBean<HostKeyPairProvider>
implements DisposableBean {
    private final ServiceTracker<DmzSecretService, DmzSecretService> secretService;
    private final ServiceTracker<DmzMirrorFarm, DmzMirrorFarm> mirrorFarm;
    private final PluginEventManager pluginEventManager;
    private final ApplicationPropertiesService propertiesService;
    private final StorageService storageService;
    private String algorithm;
    private int keySize;

    public HostKeyPairProviderFactory(BundleContext bundleContext, PluginEventManager pluginEventManager, ApplicationPropertiesService propertiesService, StorageService storageService) {
        this.pluginEventManager = pluginEventManager;
        this.propertiesService = propertiesService;
        this.storageService = storageService;
        this.secretService = new ServiceTracker(bundleContext, DmzSecretService.class, null);
        this.secretService.open();
        this.mirrorFarm = new ServiceTracker(bundleContext, DmzMirrorFarm.class, null);
        this.mirrorFarm.open();
    }

    public void destroy() throws Exception {
        this.secretService.close();
        this.mirrorFarm.close();
        super.destroy();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public Class<?> getObjectType() {
        return HostKeyPairProvider.class;
    }

    protected HostKeyPairProvider createInstance() {
        DefaultHostKeyPairProvider provider = this.propertiesService.getMode() == ApplicationMode.MIRROR ? new MirrorHostKeyPairProvider(Objects.requireNonNull((DmzMirrorFarm)this.mirrorFarm.getService(), "mirrorFarm"), this.pluginEventManager, Objects.requireNonNull((DmzSecretService)this.secretService.getService(), "secretService"), this.storageService) : new DefaultHostKeyPairProvider(this.storageService);
        provider.setAlgorithm(this.algorithm);
        provider.setKeySize(this.keySize);
        if (provider instanceof InitializingBean) {
            ((MirrorHostKeyPairProvider)provider).afterPropertiesSet();
        }
        return provider;
    }

    protected void destroyInstance(HostKeyPairProvider instance) throws Exception {
        if (instance instanceof DisposableBean) {
            ((DisposableBean)instance).destroy();
        }
    }
}

