/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.internal.ssh.server.SessionAttributes;
import com.atlassian.johnson.Johnson;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.google.common.collect.ImmutableList;
import jakarta.servlet.ServletContext;
import java.security.PublicKey;
import java.util.Collection;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class JohnsonAwarePublicKeyAuthenticator
implements PublickeyAuthenticator {
    private final ServletContextFactory servletContextFactory;
    private final PublickeyAuthenticator publicKeyAuthenticator;

    public JohnsonAwarePublicKeyAuthenticator(ServletContextFactory servletContextFactory, PublickeyAuthenticator publicKeyAuthenticator) {
        this.servletContextFactory = servletContextFactory;
        this.publicKeyAuthenticator = publicKeyAuthenticator;
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        ImmutableList events = ImmutableList.copyOf((Collection)Johnson.getEventContainer((ServletContext)this.servletContextFactory.getServletContext()).getEvents());
        if (!events.isEmpty()) {
            session.setAttribute(SessionAttributes.ATTRIBUTE_JOHNSON_EVENTS, events);
            return true;
        }
        return this.publicKeyAuthenticator.authenticate(username, key, session);
    }
}

