/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.dmz.mirror.DmzSecretService;
import com.atlassian.bitbucket.dmz.mirror.event.MirrorBootstrappedEvent;
import com.atlassian.bitbucket.internal.ssh.server.DefaultHostKeyPairProvider;
import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MirrorHostKeyPairProvider
extends DefaultHostKeyPairProvider
implements InitializingBean,
DisposableBean {
    private static final JcaPEMKeyConverter JCA_PEM_KEY_CONVERTER = new JcaPEMKeyConverter();
    private static final String SECRET_NAME = "ssh_server_key";
    private final int bootstrapWaitSeconds;
    private final CountDownLatch farmBootstrappedLatch;
    private final DmzMirrorFarm mirrorFarm;
    private final PluginEventManager pluginEventManager;
    private final DmzSecretService secretService;

    @VisibleForTesting
    MirrorHostKeyPairProvider(DmzMirrorFarm mirrorFarm, PluginEventManager pluginEventManager, DmzSecretService secretService, StorageService storageService, int bootstrapWaitSeconds) {
        super(storageService);
        this.mirrorFarm = mirrorFarm;
        this.pluginEventManager = pluginEventManager;
        this.secretService = secretService;
        this.bootstrapWaitSeconds = bootstrapWaitSeconds;
        this.farmBootstrappedLatch = new CountDownLatch(1);
    }

    public MirrorHostKeyPairProvider(DmzMirrorFarm mirrorFarm, PluginEventManager pluginEventManager, DmzSecretService secretService, StorageService storageService) {
        this(mirrorFarm, pluginEventManager, secretService, storageService, 120);
    }

    public void afterPropertiesSet() {
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() {
        this.pluginEventManager.unregister((Object)this);
    }

    @EventListener
    public void onMirrorBootstrapped(MirrorBootstrappedEvent ignored) {
        this.shareKeyFileWithFarm();
        this.farmBootstrappedLatch.countDown();
    }

    @Override
    public void onStart() {
        if (this.mirrorFarm.isBootstrapped()) {
            this.shareKeyFileWithFarm();
            this.farmBootstrappedLatch.countDown();
        }
    }

    @Override
    protected KeyPair generateKeyPair(String algorithm) throws GeneralSecurityException {
        this.waitUntilFarmIsBootstrapped();
        try {
            return MirrorHostKeyPairProvider.parsePemKeyPair((byte[])this.secretService.computeIfAbsent(SECRET_NAME, () -> {
                try {
                    KeyPair keyPair = MirrorHostKeyPairProvider.super.generateKeyPair(algorithm);
                    this.log.debug("generateKeyPair({}) generated key pair - sharing with mirror farm...", (Object)algorithm);
                    return MirrorHostKeyPairProvider.toByteArray((IoConsumer<OutputStream>)((IoConsumer)os -> this.doWriteKeyPair(keyPair, (OutputStream)os)));
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)e.getCause();
            }
            throw e;
        }
    }

    @VisibleForTesting
    void waitUntilFarmIsBootstrapped() {
        try {
            if (!this.farmBootstrappedLatch.await(this.bootstrapWaitSeconds, TimeUnit.SECONDS)) {
                throw new RuntimeException("Timed out waiting for farm to be bootstrapped. Aborting.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for farm to be bootstrapped", e);
        }
    }

    private static KeyPair parsePemKeyPair(byte[] data) {
        KeyPair keyPair;
        PEMParser parser = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(data)));
        try {
            Object obj = parser.readObject();
            if (!(obj instanceof PEMKeyPair)) {
                throw new IllegalArgumentException("Farm did not contain valid PEM key pair");
            }
            keyPair = JCA_PEM_KEY_CONVERTER.getKeyPair((PEMKeyPair)obj);
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        parser.close();
        return keyPair;
    }

    private static byte[] toByteArray(IoConsumer<OutputStream> consumer) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            consumer.accept((Object)buf);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buf.toByteArray();
    }

    private void shareKeyFileWithFarm() {
        this.secretService.computeIfAbsent(SECRET_NAME, () -> {
            Path keyFile = this.getPath();
            if (Files.exists(keyFile, new LinkOption[0])) {
                this.log.debug("({}) key pair exists on disk. Sharing with mirror farm...", (Object)keyFile);
                return MirrorHostKeyPairProvider.toByteArray((IoConsumer<OutputStream>)((IoConsumer)os -> Files.copy(keyFile, os)));
            }
            this.log.debug("({}) no key pair exists on disk.", (Object)keyFile);
            return null;
        });
    }
}

