/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.server.channel.ChannelSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmHostingChannelSession
extends ChannelSession {
    private static final long DEFAULT_CLOSE_TIMEOUT = 30000L;
    private static final String CLOSE_TIMEOUT = "channel-close-timeout";

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(super.getInnerCloseable(), new ScmHostingChannelSessionCloseable(this)).build();
    }

    @Override
    protected void preClose() {
        super.preClose();
    }

    private static class ScmHostingChannelSessionCloseable
    implements Closeable {
        private static final Logger log = LoggerFactory.getLogger(ScmHostingChannelSessionCloseable.class);
        private final ScmHostingChannelSession session;

        private ScmHostingChannelSessionCloseable(ScmHostingChannelSession session) {
            this.session = session;
        }

        @Override
        public CloseFuture close(boolean immediately) {
            if (!this.session.closeFuture.isDone()) {
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            session.handleClose();
                        }
                        catch (IOException e) {
                            log.warn("Failed to force close channel {}. Marking it as closed anyway", (Object)session.getChannelId(), (Object)e);
                            session.closeFuture.setClosed();
                        }
                    }
                };
                this.session.getSession().getFactoryManager().getScheduledExecutorService().schedule(task, this.getCloseTimeoutInMs(), TimeUnit.MILLISECONDS);
                this.session.closeFuture.addListener(ignored -> task.cancel());
            }
            return this.session.closeFuture;
        }

        @Override
        public void addCloseFutureListener(SshFutureListener<CloseFuture> listener) {
            this.session.addCloseFutureListener(listener);
        }

        @Override
        public void removeCloseFutureListener(SshFutureListener<CloseFuture> listener) {
            this.session.removeCloseFutureListener(listener);
        }

        @Override
        public boolean isClosed() {
            return this.session.isClosed();
        }

        @Override
        public boolean isClosing() {
            return this.session.isClosing();
        }

        private long getCloseTimeoutInMs() {
            long timeout = 30000L;
            try {
                Long configuredTimeout = PropertyResolverUtils.getLong(this.session.getSession(), ScmHostingChannelSession.CLOSE_TIMEOUT);
                if (configuredTimeout != null) {
                    timeout = configuredTimeout;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return timeout;
        }
    }
}

