/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;

public class SessionTracker
implements SessionListener {
    private final AtomicLong maxActiveSessionCount = new AtomicLong();
    private final LongAdder sessionClosedCount = new LongAdder();
    private final LongAdder sessionCreatedCount = new LongAdder();
    private final LongAdder sessionExceptionCount = new LongAdder();
    private final LongAdder sessionDisconnectedLimitCount = new LongAdder();

    SessionTracker() {
    }

    @Override
    public void sessionCreated(Session session) {
    }

    @Override
    public void sessionEvent(Session session, SessionListener.Event event) {
        if (event == SessionListener.Event.Authenticated) {
            this.sessionCreatedCount.increment();
            long active = this.sessionCreatedCount.sum() - this.sessionClosedCount.sum();
            this.maxActiveSessionCount.accumulateAndGet(active, Math::max);
        }
    }

    @Override
    public void sessionException(Session session, Throwable t) {
        this.sessionExceptionCount.increment();
    }

    @Override
    public void sessionClosed(Session session) {
        if (session.isAuthenticated()) {
            this.sessionClosedCount.increment();
        }
    }

    @Override
    public void sessionDisconnect(Session session, int reason, String msg, String language, boolean initiator) {
        if (reason == 12) {
            this.sessionDisconnectedLimitCount.increment();
        }
    }

    long getActiveSessionCount() {
        return this.sessionCreatedCount.sum() - this.sessionClosedCount.sum();
    }

    long getMaxActiveSessionCount() {
        return this.maxActiveSessionCount.get();
    }

    long getSessionClosedCount() {
        return this.sessionClosedCount.sum();
    }

    long getSessionCreatedCount() {
        return this.sessionCreatedCount.sum();
    }

    long getSessionExceptionCount() {
        return this.sessionExceptionCount.sum();
    }

    long getSessionDisconnectedLimitCount() {
        return this.sessionDisconnectedLimitCount.sum();
    }
}

