/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.auth.SimpleAuthentication;
import com.atlassian.bitbucket.internal.ssh.server.SshCredentials;
import com.atlassian.bitbucket.internal.ssh.server.SshKeyDetails;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class SshAuthentication {
    private final SshCredentials credentials;
    private final SshKeyDetails keyDetails;
    private final Map<String, Serializable> properties;
    private final ApplicationUser user;

    public SshAuthentication(@Nonnull SshCredentials credentials, @Nonnull SshKeyDetails keyDetails, @Nonnull Map<String, Serializable> properties, @Nonnull ApplicationUser user) {
        this.credentials = Objects.requireNonNull(credentials, "credentials");
        this.keyDetails = Objects.requireNonNull(keyDetails, "keyDetails");
        this.properties = Objects.requireNonNull(properties, "properties");
        this.user = Objects.requireNonNull(user, "user");
    }

    @Nonnull
    public SshCredentials getCredentials() {
        return this.credentials;
    }

    @Nonnull
    public SshKeyDetails getKeyDetails() {
        return this.keyDetails;
    }

    @Nonnull
    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    @Nonnull
    public Authentication toAuthentication() {
        return new SimpleAuthentication.Builder(this.user).properties(this.properties).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SshAuthentication)) {
            return false;
        }
        SshAuthentication that = (SshAuthentication)o;
        return com.google.common.base.Objects.equal((Object)this.credentials, (Object)that.credentials) && com.google.common.base.Objects.equal((Object)this.keyDetails, (Object)that.keyDetails) && com.google.common.base.Objects.equal(this.properties, that.properties) && com.google.common.base.Objects.equal((Object)this.user, (Object)that.user);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.credentials, this.keyDetails, this.properties, this.user});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("credentials", (Object)this.credentials).add("keyDetails", (Object)this.keyDetails).add("properties", this.properties).add("user", (Object)this.user).toString();
    }
}

