/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.auth.InactiveUserAuthenticationException;
import com.atlassian.bitbucket.dmz.request.DmzRequestContext;
import com.atlassian.bitbucket.dmz.ssh.SshAuthenticationSuccessEvent;
import com.atlassian.bitbucket.dmz.user.AuthorizationFailureEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.auth.PluginSshAuthenticationHandler;
import com.atlassian.bitbucket.internal.ssh.command.SshCommandProvider;
import com.atlassian.bitbucket.internal.ssh.event.SshAuthenticationFailureEvent;
import com.atlassian.bitbucket.internal.ssh.server.ChunkedOutputStream;
import com.atlassian.bitbucket.internal.ssh.server.DefaultSshAuthenticationFailureContext;
import com.atlassian.bitbucket.internal.ssh.server.DefaultSshAuthenticationSuccessContext;
import com.atlassian.bitbucket.internal.ssh.server.HaProxyProtocolAcceptor;
import com.atlassian.bitbucket.internal.ssh.server.HighLoadLogger;
import com.atlassian.bitbucket.internal.ssh.server.SessionAttributes;
import com.atlassian.bitbucket.internal.ssh.server.SshAuthentication;
import com.atlassian.bitbucket.internal.ssh.server.SshKeyDetails;
import com.atlassian.bitbucket.internal.ssh.server.StreamDataReceiver;
import com.atlassian.bitbucket.internal.ssh.utils.NamePreservingRunnable;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.repository.RepositoryReadOnlyException;
import com.atlassian.bitbucket.request.RequestCallback;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.request.RequestMetadata;
import com.atlassian.bitbucket.scm.AuthenticationState;
import com.atlassian.bitbucket.ssh.command.SshCommand;
import com.atlassian.bitbucket.ssh.command.SshCommandContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.Event;
import com.google.common.io.CountingOutputStream;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.zip.CRC32;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.channel.exception.SshChannelClosedException;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.channel.ChannelSessionAware;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshCommandAdapter
implements Command,
ChannelSessionAware,
RequestInfoProvider,
ServerSessionAware {
    private static final Logger log = LoggerFactory.getLogger(SshCommandAdapter.class);
    private final PluginSshAuthenticationHandler authenticationHandler;
    private final AuthenticationService authenticationService;
    private final String commandString;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RequestManager requestManager;
    private final SshCommandProvider sshCommandProvider;
    private final UserService userService;
    private StreamDataReceiver dataReceiver;
    private ExitCallback exitCallback;
    private CountingOutputStream outputStream;
    private OutputStream errorStream;
    private String remoteAddress;
    private ServerSession session;
    private String sessionId;
    private volatile boolean canceled;
    private volatile SshCommand command;
    private HighLoadLogger isUserActiveHighLoadLogger;

    public SshCommandAdapter(PluginSshAuthenticationHandler authenticationHandler, AuthenticationService authenticationService, String commandString, EventPublisher eventPublisher, ExecutorService executorService, I18nService i18nService, RequestManager requestManager, SshCommandProvider sshCommandProvider, UserService userService, HighLoadLogger isUserActiveHighLoadLogger) {
        this.authenticationHandler = Objects.requireNonNull(authenticationHandler, "authenticationHandler");
        this.authenticationService = Objects.requireNonNull(authenticationService, "authenticationService");
        this.commandString = Objects.requireNonNull(commandString, "commandString");
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.requestManager = Objects.requireNonNull(requestManager, "requestManager");
        this.sshCommandProvider = Objects.requireNonNull(sshCommandProvider, "sshCommandProvider");
        this.userService = Objects.requireNonNull(userService, "userService");
        this.isUserActiveHighLoadLogger = Objects.requireNonNull(isUserActiveHighLoadLogger, "isUserActiveHighLoadLogger");
    }

    @Override
    public void destroy(ChannelSession channelSession) {
        SshCommand command = this.command;
        if (command != null) {
            this.canceled = true;
            command.cancel();
        }
    }

    @Nonnull
    public String getAction() {
        return "SSH - " + this.commandString;
    }

    public String getDetails() {
        return StringUtils.wrap((String)this.session.getClientVersion(), (char)'\"');
    }

    @Nonnull
    public String getProtocol() {
        return "ssh";
    }

    @Nonnull
    public Object getRawRequest() {
        return this;
    }

    @Nonnull
    public Object getRawResponse() {
        return this;
    }

    public String getRemoteAddress() {
        InetAddress inetAddress;
        InetSocketAddress socketAddress;
        if (this.remoteAddress == null && (socketAddress = (InetSocketAddress)this.session.getClientAddress()) != null && (inetAddress = socketAddress.getAddress()) != null) {
            StringBuilder builder = new StringBuilder();
            InetSocketAddress proxiedAddress = (InetSocketAddress)this.session.getAttribute(HaProxyProtocolAcceptor.ATTRIBUTE_PROXIED_ADDRESS);
            if (proxiedAddress != null) {
                builder.append(proxiedAddress.getAddress().getHostAddress()).append(',');
            }
            this.remoteAddress = builder.append(inetAddress.getHostAddress()).toString();
        }
        return this.remoteAddress;
    }

    public String getSessionId() {
        if (this.sessionId == null) {
            CRC32 crc = new CRC32();
            crc.update(DigestUtils.sha1((byte[])this.session.getSessionId()));
            this.sessionId = Long.toString(crc.getValue(), 36);
        }
        return this.sessionId;
    }

    public boolean hasSessionId() {
        return true;
    }

    public boolean isSecure() {
        return true;
    }

    @Override
    public void setChannelSession(ChannelSession session) {
        this.dataReceiver = new StreamDataReceiver(session, (RequestMetadata)this);
        session.setDataReceiver(this.dataReceiver);
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.errorStream = err;
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.exitCallback = callback;
    }

    @Override
    public void setInputStream(InputStream in) {
        throw new UnsupportedOperationException("setInputStream should not be called when a custom ChannelDataReceiver is in use");
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.outputStream = new CountingOutputStream(out);
    }

    @Override
    public void setSession(ServerSession session) {
        this.session = session;
    }

    @Override
    public void start(ChannelSession channelSession, Environment env) throws IOException {
        List<Event> johnsonEvents = this.session.getAttribute(SessionAttributes.ATTRIBUTE_JOHNSON_EVENTS);
        if (johnsonEvents != null) {
            this.handleJohnsoned(johnsonEvents);
            return;
        }
        String keyInsecure = this.session.getAttribute(SessionAttributes.ATTRIBUTE_KEY_INSECURE);
        if (keyInsecure != null) {
            this.handleBlocked(keyInsecure);
            return;
        }
        String keyExpiredMessage = this.session.getAttribute(SessionAttributes.ATTRIBUTE_KEY_EXPIRED);
        if (keyExpiredMessage != null) {
            this.handleBlocked(keyExpiredMessage);
            return;
        }
        SshAuthentication authentication = this.session.getAttribute(SessionAttributes.ATTRIBUTE_AUTH);
        if (authentication == null) {
            this.handleNoAuthentication();
            return;
        }
        this.executorService.execute(new NamePreservingRunnable(new SshCommandRunnable(authentication, env, this.isUserActiveHighLoadLogger), "ssh-scm-request-handler"));
    }

    private void handleBlocked(String keyExpiredMessage) {
        this.writeErrorAndExit(keyExpiredMessage);
    }

    private void handleJohnsoned(List<Event> events) throws IOException {
        this.errorStream.write((Product.NAME + " is currently unavailable:\n").getBytes(StandardCharsets.UTF_8));
        for (Event event : events) {
            this.errorStream.write(("- " + event.getDesc() + "\n").getBytes(StandardCharsets.UTF_8));
        }
        this.errorStream.flush();
        this.exitCallback.onExit(1);
    }

    private void handleNoAuthentication() {
        log.error("No user or SSH key access entries set in SSH ServerSession! Terminating SSH command.");
        this.exitCallback.onExit(1);
    }

    private void handleNoCommand() {
        log.debug("{}: Command is not supported; no handler is available", (Object)this.commandString);
        this.writeErrorAndExit(this.i18nService.getMessage("bitbucket.plugin.ssh.request.handler.notfound", new Object[]{Product.NAME, this.commandString}));
    }

    private void writeErrorAndExit(String message) {
        try {
            this.errorStream.write(message.getBytes());
            this.errorStream.write(10);
            this.errorStream.flush();
        }
        catch (SocketTimeoutException e) {
            log.debug("Timed out writing error message to remote client while disconnecting for command '{}'", (Object)this.commandString);
        }
        catch (WindowClosedException | SshChannelClosedException e) {
            log.debug("Failed to write error message to remote client for command '{}'. Client has disconnected", (Object)this.commandString);
        }
        catch (Exception e) {
            log.info("Failed to write error message to remote client", (Throwable)e);
        }
        finally {
            this.exitCallback.onExit(1);
        }
    }

    private class SshCommandRunnable
    implements Runnable {
        private final SshAuthentication authentication;
        private final Environment environment;
        private final HighLoadLogger isUserActiveHighLoadLogger;

        SshCommandRunnable(SshAuthentication authentication, Environment environment, HighLoadLogger isUserActiveHighLoadLogger) {
            this.authentication = Objects.requireNonNull(authentication, "authentication");
            this.environment = Objects.requireNonNull(environment, "environment");
            this.isUserActiveHighLoadLogger = isUserActiveHighLoadLogger;
        }

        @Override
        public void run() {
            SshCommandAdapter.this.authenticationService.set(this.authentication.toAuthentication());
            try {
                SshCommandAdapter.this.requestManager.doAsRequest((RequestCallback)new OperationRequestAdapter(), (RequestInfoProvider)SshCommandAdapter.this);
            }
            catch (IOException e) {
                if (SshCommandAdapter.this.canceled) {
                    log.debug("Exception encountered handling canceled SSH command '" + SshCommandAdapter.this.commandString + "'", (Throwable)e);
                }
                log.warn("Exception encountered handling SSH command '{}'", (Object)SshCommandAdapter.this.commandString, (Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performAsRequest(@Nonnull DmzRequestContext requestContext) {
            ApplicationUser user = this.authentication.getUser();
            SshKeyDetails keyDetails = this.authentication.getKeyDetails();
            requestContext.setAuthenticatedUser(user);
            requestContext.addLabel("ssh:user:id:" + user.getId());
            if (!StringUtils.isEmpty((CharSequence)keyDetails.getId())) {
                requestContext.addLabel("ssh:id:" + keyDetails.getId());
            }
            if (!StringUtils.isEmpty((CharSequence)keyDetails.getLabel())) {
                requestContext.addLabel("ssh:label:" + keyDetails.getLabel());
            }
            if (!this.verifyAuthentication(user)) {
                log.info("{} was successfully authenticated via public key, but is no longer active in the underlying user directory. The request has been blocked", (Object)this.authentication.getCredentials().getUsername());
                SshCommandAdapter.this.exitCallback.onExit(1);
                return;
            }
            this.handleAuthSuccess();
            int exitCode = 1;
            try {
                SshCommandContext context = new SshCommandContext.Builder(SshCommandAdapter.this.commandString, (InputStream)SshCommandAdapter.this.dataReceiver.getIn(), (OutputStream)new CloseShieldOutputStream((OutputStream)((Object)new ChunkedOutputStream((OutputStream)SshCommandAdapter.this.outputStream))), (OutputStream)new CloseShieldOutputStream(SshCommandAdapter.this.errorStream)).environment(this.environment.getEnv()).build();
                SshCommandAdapter.this.command = SshCommandAdapter.this.sshCommandProvider.getSshCommand(context).orElse(null);
                if (SshCommandAdapter.this.command == null) {
                    SshCommandAdapter.this.handleNoCommand();
                    return;
                }
                exitCode = SshCommandAdapter.this.command.run();
            }
            catch (AuthorisationException | NoSuchRepositoryException e) {
                String message = SshCommandAdapter.this.i18nService.getMessage("bitbucket.scm.no.such.repository", new Object[0]) + "\n" + SshCommandAdapter.this.i18nService.getMessage("bitbucket.scm.no.such.repository.detail", new Object[0]);
                SshCommandAdapter.this.writeErrorAndExit(message);
                if (e instanceof AuthorisationException) {
                    SshCommandAdapter.this.eventPublisher.publish((Object)new AuthorizationFailureEvent((Object)this));
                }
            }
            catch (SocketTimeoutException e) {
                log.info("SSH command '{}' timed out communicating with the remote client", (Object)SshCommandAdapter.this.commandString);
            }
            catch (WindowClosedException | SshChannelClosedException e) {
                log.debug("Client closed connection for SSH command '{}'", (Object)SshCommandAdapter.this.commandString);
            }
            catch (RepositoryOfflineException e) {
                log.debug("Repository is offline for SSH command '{}'", (Object)SshCommandAdapter.this.commandString, (Object)e);
                SshCommandAdapter.this.writeErrorAndExit(SshCommandAdapter.this.i18nService.getMessage("bitbucket.scm.repository.offline", new Object[0]));
            }
            catch (RepositoryReadOnlyException e) {
                log.debug("Repository is in read-only mode for SSH command '{}'", (Object)SshCommandAdapter.this.commandString, (Object)e);
                SshCommandAdapter.this.writeErrorAndExit(SshCommandAdapter.this.i18nService.getMessage("bitbucket.scm.repository.readonly", new Object[0]));
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.warn("Error encountered while handling SSH command '{}'", (Object)SshCommandAdapter.this.commandString, (Object)e);
                } else {
                    log.warn("Error encountered while handling SSH command '{}': {}", (Object)SshCommandAdapter.this.commandString, (Object)e.toString());
                }
                SshCommandAdapter.this.writeErrorAndExit(SshCommandAdapter.this.i18nService.getMessage("bitbucket.ssh.command.failed", new Object[0]));
            }
            finally {
                SshCommandAdapter.this.exitCallback.onExit(exitCode);
                requestContext.setResponseCode(exitCode);
                requestContext.setBytesRead(SshCommandAdapter.this.dataReceiver.getCount());
                requestContext.setBytesWritten(SshCommandAdapter.this.outputStream.getCount());
            }
        }

        private boolean verifyAuthentication(ApplicationUser user) {
            boolean userActive = this.verifyUserIsActive(user);
            if (userActive) {
                return true;
            }
            InactiveUserAuthenticationException exception = new InactiveUserAuthenticationException(SshCommandAdapter.this.i18nService.createKeyedMessage("bitbucket.auth.crowd.sso.inactive.account", new Object[0]));
            SshCommandAdapter.this.eventPublisher.publish((Object)new SshAuthenticationFailureEvent(this, this.authentication.getCredentials().getUsername(), (AuthenticationException)exception));
            SshCommandAdapter.this.authenticationHandler.onAuthenticationFailure(new DefaultSshAuthenticationFailureContext(this.authentication.getCredentials(), AuthenticationState.NOT_AUTHENTICATED, (AuthenticationException)exception));
            return false;
        }

        private boolean verifyUserIsActive(ApplicationUser user) {
            try {
                this.isUserActiveHighLoadLogger.enter();
                boolean bl = SshCommandAdapter.this.userService.isUserActive(user);
                return bl;
            }
            finally {
                this.isUserActiveHighLoadLogger.exit();
            }
        }

        private void handleAuthSuccess() {
            ApplicationUser user = this.authentication.getUser();
            SshKeyDetails keyDetails = this.authentication.getKeyDetails();
            String tokenDetails = "sshKey {" + (String)(!StringUtils.isEmpty((CharSequence)keyDetails.getId()) ? "\"id\":\"" + keyDetails.getId() + "\", " : "") + (String)(!StringUtils.isEmpty((CharSequence)keyDetails.getLabel()) ? "\"label\":\"" + keyDetails.getLabel() + "\", " : "") + "\"user.id\":" + user.getId() + "\", \"name\":\"" + user.getDisplayName() + "\"}";
            SshCommandAdapter.this.eventPublisher.publish((Object)new SshAuthenticationSuccessEvent((Object)this, this.authentication.getCredentials().getPublicKey(), tokenDetails, user));
            SshCommandAdapter.this.authenticationHandler.onAuthenticationSuccess(new DefaultSshAuthenticationSuccessContext(this.authentication, SshCommandAdapter.this.commandString));
        }

        private class OperationRequestAdapter
        implements RequestCallback<Void, IOException> {
            private OperationRequestAdapter() {
            }

            public Void withRequest(@Nonnull RequestContext requestContext) {
                SshCommandRunnable.this.performAsRequest((DmzRequestContext)requestContext);
                return null;
            }
        }
    }
}

