/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.auth.PluginSshAuthenticationHandler;
import com.atlassian.bitbucket.internal.ssh.command.SshCommandProvider;
import com.atlassian.bitbucket.internal.ssh.server.HighLoadLogger;
import com.atlassian.bitbucket.internal.ssh.server.SshCommandAdapter;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventPublisher;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;

public class SshCommandAdapterCommandFactory
implements CommandFactory {
    private final PluginSshAuthenticationHandler authenticationHandler;
    private final AuthenticationService authenticationService;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final HighLoadLogger isUserActiveHighLoadLogger;
    private final RequestManager requestManager;
    private final SshCommandProvider sshCommandProvider;
    private final UserService userService;

    public SshCommandAdapterCommandFactory(PluginSshAuthenticationHandler authenticationHandler, AuthenticationService authenticationService, EventPublisher eventPublisher, ExecutorService executorService, I18nService i18nService, RequestManager requestManager, SshCommandProvider sshCommandProvider, UserService userService, ApplicationPropertiesService propertiesService) {
        this.authenticationHandler = authenticationHandler;
        this.authenticationService = authenticationService;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.requestManager = requestManager;
        this.sshCommandProvider = sshCommandProvider;
        this.userService = userService;
        int sshSessionMax = propertiesService.getPluginProperty("plugin.ssh.session.max", 250);
        this.isUserActiveHighLoadLogger = new HighLoadLogger((int)((double)sshSessionMax * 0.8), "Possible bottleneck in directory service. Consider increasing the cache time (auth.remote.cache.ttl) or addressing slow directory server performance", 1);
    }

    @Override
    public Command createCommand(ChannelSession channelSession, String remoteCommand) {
        return new SshCommandAdapter(this.authenticationHandler, this.authenticationService, remoteCommand, this.eventPublisher, this.executorService, this.i18nService, this.requestManager, this.sshCommandProvider, this.userService, this.isUserActiveHighLoadLogger);
    }
}

