/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import java.util.concurrent.atomic.LongAdder;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectionLimiter
implements SessionListener {
    private static final Logger log = LoggerFactory.getLogger(SshConnectionLimiter.class);
    private final LongAdder activeConnectionCount;
    private final int maxConnections;

    SshConnectionLimiter(int maxConnections) {
        this.maxConnections = maxConnections;
        this.activeConnectionCount = new LongAdder();
    }

    @Override
    public void sessionClosed(Session session) {
        this.activeConnectionCount.decrement();
    }

    @Override
    public void sessionEstablished(Session session) {
        this.activeConnectionCount.increment();
        long activeCount = this.activeConnectionCount.sum();
        if (activeCount > (long)this.maxConnections) {
            log.info("Rejecting SSH connection because active connection count ({}) has exceeded the limit ({})", (Object)activeCount, (Object)this.maxConnections);
            session.close(true);
        }
    }
}

