/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

public class SshKeyDetails {
    private String id;
    private String label;

    public SshKeyDetails(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("label", (Object)this.label).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshKeyDetails that = (SshKeyDetails)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.label, (Object)that.label);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.label});
    }

    public static SshKeyDetails getFromMDC() {
        return new SshKeyDetails(MDC.get((String)"ssh:id"), MDC.get((String)"ssh:label"));
    }

    public void putInMDC() {
        SshKeyDetails.putInMDCIfNotEmpty("ssh:id", this.id);
        SshKeyDetails.putInMDCIfNotEmpty("ssh:label", this.label);
    }

    private static void putInMDCIfNotEmpty(String key, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            MDC.put((String)key, (String)value);
        }
    }
}

