/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.internal.ssh.server.DrainableSshServer;
import com.atlassian.bitbucket.internal.ssh.server.SessionTracker;
import com.atlassian.bitbucket.internal.ssh.server.SshServerFactory;
import com.atlassian.bitbucket.internal.ssh.server.SshServerState;
import com.atlassian.bitbucket.internal.ssh.server.SshServerStatus;
import com.atlassian.bitbucket.internal.ssh.server.SshSessionsMxBeanAdapter;
import com.atlassian.bitbucket.internal.ssh.service.SshConfigurationRefreshEvent;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.shutdown.ShutdownHook;
import com.atlassian.bitbucket.shutdown.ShutdownHookStatus;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.event.SshConfigurationChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.Optional;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public class SshServer
implements LifecycleAware,
Ordered,
ShutdownHook {
    private static final Logger log = LoggerFactory.getLogger(SshServer.class);
    private static final String MXBEAN_NAME = "com.atlassian.bitbucket:name=SshSessions";
    private final boolean jmxEnabled;
    private final Object lock;
    private final SshConfigurationService sshConfigurationService;
    private final SshServerFactory sshServerFactory;
    private volatile SessionTracker sessionTracker;
    private volatile DrainableSshServer sshServer;
    private volatile SshServerStatus status;

    public SshServer(SshConfigurationService configurationService, ApplicationPropertiesService propertiesService, SshServerFactory sshServerFactory) {
        this.sshConfigurationService = configurationService;
        this.sshServerFactory = sshServerFactory;
        this.jmxEnabled = propertiesService.isJmxEnabled();
        this.lock = new Object();
        this.status = SshServerStatus.forState(SshServerState.STOPPED);
    }

    public int getOrder() {
        return 10;
    }

    public SshServerStatus getSshServerStatus() {
        return this.status;
    }

    @Nonnull
    public ShutdownHookStatus getStatus() {
        return this.sshServer == null || this.sshServer.isIdle() ? ShutdownHookStatus.IDLE : ShutdownHookStatus.ACTIVE;
    }

    public boolean isRunning() {
        return this.sshServer != null && this.status.getState() == SshServerState.RUNNING;
    }

    @EventListener
    public void onConfigurationChange(SshConfigurationChangedEvent event) {
        this.synchronizeStateFrom(event.getNewConfiguration());
    }

    @EventListener
    public void onConfigurationRefresh(SshConfigurationRefreshEvent event) {
        this.synchronizeStateFrom(this.sshConfigurationService.getConfiguration());
    }

    public void onStart() {
        SshConfiguration sshConfiguration = this.sshConfigurationService.getConfiguration();
        if (sshConfiguration.isEnabled()) {
            this.startServer(sshConfiguration.getPort());
        }
    }

    public void onStop() {
        this.stopServer();
    }

    public void startShutdown(@Nonnull Duration ignored) {
        if (this.sshServer != null) {
            this.sshServer.unbind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(int port) {
        if (this.status.getState() != SshServerState.RUNNING) {
            Object object = this.lock;
            synchronized (object) {
                if (this.status.getState() != SshServerState.RUNNING) {
                    this.startServerInternal(port);
                }
            }
        }
        if (this.jmxEnabled) {
            this.registerMxBean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        if (this.jmxEnabled) {
            this.unregisterMxBean();
        }
        if (this.status.getState() != SshServerState.STOPPED) {
            Object object = this.lock;
            synchronized (object) {
                if (this.status.getState() != SshServerState.STOPPED) {
                    this.stopServerInternal();
                }
            }
        }
    }

    public Optional<Integer> getPort() {
        return this.status.getState() == SshServerState.RUNNING ? Optional.of(this.sshServer.getPort()) : Optional.empty();
    }

    private void registerMxBean() {
        if (this.sessionTracker == null) {
            this.sessionTracker = new SessionTracker();
        }
        this.sshServer.addSessionListener(this.sessionTracker);
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(new SshSessionsMxBeanAdapter(this.sessionTracker), new ObjectName(MXBEAN_NAME));
        }
        catch (RuntimeException | JMException e) {
            log.warn("Could not registers SshSessions MXBean. SSH details will not be available in JMX", (Throwable)e);
            this.sshServer.removeSessionListener(this.sessionTracker);
            this.sessionTracker = null;
        }
    }

    private void startServerInternal(int port) {
        try {
            log.info("Starting SSH server on port {}...", (Object)port);
            this.sshServer = this.sshServerFactory.createServer(port);
            this.sshServer.start();
            this.status = SshServerStatus.forState(SshServerState.RUNNING);
            log.info("Started SSH server successfully.");
        }
        catch (IOException e) {
            this.status = SshServerStatus.forException(e);
            log.error("SSH server failed to start", (Throwable)e);
        }
    }

    private void stopServerInternal() {
        if (this.isRunning()) {
            try {
                log.info("Stopping SSH server...");
                this.sshServer.stop(true);
                log.info("Stopped SSH server successfully.");
            }
            catch (InterruptedIOException e) {
                log.warn("Interrupted while waiting for SSH server to stop; some sessions may still be active", (Throwable)e);
            }
            catch (IOException e) {
                log.warn("The SSH server could not be stopped", (Throwable)e);
            }
        }
        this.status = SshServerStatus.forState(SshServerState.STOPPED);
    }

    private void synchronizeStateFrom(SshConfiguration configuration) {
        if (this.isRunning()) {
            if (!configuration.isEnabled()) {
                this.stopServer();
            } else if (this.sshServer.getPort() != configuration.getPort()) {
                this.stopServer();
                this.startServer(configuration.getPort());
            }
        } else if (configuration.isEnabled()) {
            this.startServer(configuration.getPort());
        }
    }

    private void unregisterMxBean() {
        this.sshServer.removeSessionListener(this.sessionTracker);
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(MXBEAN_NAME));
        }
        catch (RuntimeException | JMException e) {
            log.warn("Failed to unregister SshSessions MXBean", (Throwable)e);
        }
    }
}

