/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.internal.ssh.server.DefaultChannelStreamWriterResolver;
import com.atlassian.bitbucket.internal.ssh.server.DrainableSshServer;
import com.atlassian.bitbucket.internal.ssh.server.ForbiddingFileSystemFactory;
import com.atlassian.bitbucket.internal.ssh.server.HaProxyProtocolAcceptor;
import com.atlassian.bitbucket.internal.ssh.server.HostKeyPairProvider;
import com.atlassian.bitbucket.internal.ssh.server.NamedFactoryFilter;
import com.atlassian.bitbucket.internal.ssh.server.NamedFactoryType;
import com.atlassian.bitbucket.internal.ssh.server.ScmHostingChannelSessionFactory;
import com.atlassian.bitbucket.internal.ssh.server.SshConnectionLimiter;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.ThreadFactories;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.BaseBuilder;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.global.KeepAliveHandler;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.global.NoMoreSessionsHandler;

public class SshServerFactory {
    public static final int DEFAULT_SSH_SESSION_MAX = 250;
    public static final String PROP_SESSION_MAX = "plugin.ssh.session.max";
    private static final boolean DEFAULT_DH_GEX_ALLOW_SHA1 = true;
    private static final long DEFAULT_IDLE_TIMEOUT = TimeUnit.HOURS.toSeconds(2L);
    private static final int DEFAULT_MAX_PENDING_WRITES = 512;
    private static final int DEFAULT_CONNECTION_MAX = 5000;
    private static final int MINIMUM_MAX_SESSIONS = 100;
    private static final String PROP_ADDRESS = "plugin.ssh.address";
    private static final String PROP_DH_GEX_ALLOW_SHA1 = "plugin.ssh.dhgex.allow-sha1";
    private static final String PROP_IDLE_TIMEOUT = "plugin.ssh.command.timeout.idle";
    private static final String PROP_MAX_PENDING_WRITES = "plugin.ssh.session.pending-writes.max";
    private static final String PROP_NIO_WORKERS = "plugin.ssh.nio.workers";
    private static final String PROP_CONNECTION_MAX = "plugin.ssh.connection.max";
    private static final String PROP_SSH_PROXY = "plugin.ssh.haproxy.proxy-enabled";
    private static final List<BuiltinDHFactories> DH_GEX_SHA1_FACTORIES = new ImmutableList.Builder().add((Object)BuiltinDHFactories.dhg1).add((Object)BuiltinDHFactories.dhg14).add((Object)BuiltinDHFactories.dhgex).build();
    private static final List<NamedFactory<Signature>> SIGNATURE_FACTORIES = new ImmutableList.Builder().addAll(BaseBuilder.DEFAULT_SIGNATURE_PREFERENCE).add((Object)BuiltinSignatures.rsa_cert).add((Object)BuiltinSignatures.dsa).add((Object)BuiltinSignatures.dsa_cert).build();
    private final PublickeyAuthenticator authenticator;
    private final CommandFactory commandFactory;
    private final NamedFactoryFilter factoryFilter;
    private final HostKeyPairProvider keyPairProvider;
    private final ApplicationPropertiesService propertiesService;

    public SshServerFactory(PublickeyAuthenticator authenticator, CommandFactory commandFactory, HostKeyPairProvider keyPairProvider, ApplicationPropertiesService propertiesService, NamedFactoryFilter factoryFilter) {
        this.authenticator = authenticator;
        this.commandFactory = commandFactory;
        this.factoryFilter = factoryFilter;
        this.keyPairProvider = keyPairProvider;
        this.propertiesService = propertiesService;
    }

    public DrainableSshServer createServer(int port) {
        DrainableSshServer server = (DrainableSshServer)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)new ServerBuilder().factory(DrainableSshServer::new)).fileSystemFactory(new ForbiddingFileSystemFactory())).globalRequestHandlers(Arrays.asList(new KeepAliveHandler(), new NoMoreSessionsHandler()))).signatureFactories(this.factoryFilter.filter(SIGNATURE_FACTORIES, NamedFactoryType.SIGNATURE))).build();
        int dhGexKeySizeMin = this.propertiesService.getPluginProperty("plugin.ssh.dhgex-keysize.min", 1024);
        PropertyResolverUtils.updateProperty((PropertyResolver)server, CoreModuleProperties.PROP_DHGEX_SERVER_MIN_KEY.getName(), dhGexKeySizeMin);
        long idleTimout = TimeUnit.SECONDS.toMillis(this.propertiesService.getPluginProperty(PROP_IDLE_TIMEOUT, DEFAULT_IDLE_TIMEOUT));
        PropertyResolverUtils.updateProperty((PropertyResolver)server, CoreModuleProperties.IDLE_TIMEOUT.getName(), idleTimout);
        PropertyResolverUtils.updateProperty((PropertyResolver)server, CoreModuleProperties.NIO2_READ_TIMEOUT.getName(), idleTimout);
        int maxSessions = this.propertiesService.getPluginProperty(PROP_SESSION_MAX, 250);
        PropertyResolverUtils.updateProperty((PropertyResolver)server, CoreModuleProperties.MAX_CONCURRENT_SESSIONS.getName(), Math.max(maxSessions, 100));
        int maxConnections = this.propertiesService.getPluginProperty(PROP_CONNECTION_MAX, 5000);
        if (maxConnections > 0) {
            server.addSessionListener(new SshConnectionLimiter(maxConnections));
        }
        server.setChannelFactories((List<? extends ChannelFactory>)ImmutableList.of((Object)new ScmHostingChannelSessionFactory()));
        server.setChannelStreamWriterResolver(new DefaultChannelStreamWriterResolver(this.propertiesService.getPluginProperty(PROP_MAX_PENDING_WRITES, 512)));
        server.setCipherFactories(this.factoryFilter.filter(server.getCipherFactories(), NamedFactoryType.CIPHER));
        server.setCommandFactory(this.commandFactory);
        server.setCompressionFactories((List<NamedFactory<Compression>>)ImmutableList.of((Object)BuiltinCompressions.none));
        server.setForwardingFilter(null);
        server.setGSSAuthenticator(null);
        server.setHost(this.propertiesService.getPluginProperty(PROP_ADDRESS));
        server.setIoServiceFactoryFactory(new Nio2ServiceFactoryFactory());
        server.setKeyExchangeFactories(this.getKeyExchangeFactories(server));
        server.setKeyPairProvider(this.keyPairProvider);
        server.setKeyboardInteractiveAuthenticator(null);
        server.setMacFactories(this.factoryFilter.filter(server.getMacFactories(), NamedFactoryType.MAC));
        int configuredWorkers = this.propertiesService.getPluginProperty(PROP_NIO_WORKERS, -1);
        if (configuredWorkers > 0) {
            server.setNioWorkers(configuredWorkers);
        }
        server.setPasswordAuthenticator(null);
        server.setPort(port);
        server.setPublickeyAuthenticator(this.authenticator);
        server.setScheduledExecutorService(this.createScheduledExecutor(), true);
        server.setShellFactory(null);
        if (this.propertiesService.getPluginProperty(PROP_SSH_PROXY, true)) {
            server.setServerProxyAcceptor(new HaProxyProtocolAcceptor());
        }
        return server;
    }

    private ScheduledExecutorService createScheduledExecutor() {
        return Executors.newSingleThreadScheduledExecutor(ThreadFactories.namedThreadFactory((String)"ssh-server", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
    }

    private List<KeyExchangeFactory> getKeyExchangeFactories(SshServer server) {
        List<KeyExchangeFactory> keyExFactories = server.getKeyExchangeFactories();
        boolean dhGexAllowSha1 = this.propertiesService.getPluginProperty(PROP_DH_GEX_ALLOW_SHA1, true);
        if (dhGexAllowSha1) {
            List<KeyExchangeFactory> dhGexSha1Factories = NamedFactory.setUpTransformedFactories(true, DH_GEX_SHA1_FACTORIES, ServerBuilder.DH2KEX);
            keyExFactories = new ArrayList<KeyExchangeFactory>(keyExFactories);
            keyExFactories.addAll(dhGexSha1Factories);
        }
        return this.factoryFilter.filter(keyExFactories, NamedFactoryType.KEY_EXCHANGE);
    }
}

