/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.internal.ssh.server.SshServerState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Objects;

public class SshServerStatus {
    private final IOException failureCause;
    private final SshServerState state;

    private SshServerStatus(SshServerState state, IOException failureCause) {
        this.failureCause = failureCause;
        this.state = Objects.requireNonNull(state, "state");
    }

    @Nonnull
    public static SshServerStatus forException(@Nonnull IOException exception) {
        return new SshServerStatus(SshServerState.FAILED_TO_START, Objects.requireNonNull(exception, "exception"));
    }

    @Nonnull
    public static SshServerStatus forState(@Nonnull SshServerState state) {
        return new SshServerStatus(state, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshServerStatus that = (SshServerStatus)o;
        return Objects.equals(this.failureCause, that.failureCause) && this.state == that.state;
    }

    @Nullable
    public IOException getFailureCause() {
        return this.failureCause;
    }

    @Nonnull
    public SshServerState getState() {
        return this.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.failureCause, this.state});
    }
}

