/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.dmz.ssh.SshInputStream;
import com.atlassian.bitbucket.dmz.ssh.SshReadListener;
import com.atlassian.bitbucket.request.RequestMetadata;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class StreamDataReceiver
implements ChannelDataReceiver {
    private static final Logger log = LoggerFactory.getLogger(StreamDataReceiver.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicLong count = new AtomicLong();
    private final PipedSshInputStream inputStream;

    StreamDataReceiver(ChannelSession channelSession, RequestMetadata requestMetadata) {
        this.inputStream = new PipedSshInputStream(channelSession, requestMetadata);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.inputStream.eof();
        }
    }

    @Override
    public int data(ChannelSession channel, byte[] buf, int start, int len) throws IOException {
        if (this.closed.get()) {
            throw new IOException("Discarding " + len + " bytes; the stream is already closed");
        }
        this.count.addAndGet(len);
        this.inputStream.receive(buf, start, len);
        return 0;
    }

    long getCount() {
        return this.count.get();
    }

    @Nonnull
    SshInputStream getIn() {
        return this.inputStream;
    }

    private static class PipedSshInputStream
    extends SshInputStream {
        private final ChannelPipedInputStream delegate;
        private final RequestMetadata requestMetadata;
        private volatile SshReadListener readListener;

        PipedSshInputStream(ChannelSession channelSession, RequestMetadata requestMetadata) {
            this.requestMetadata = requestMetadata;
            this.delegate = new ChannelPipedInputStream(channelSession, channelSession.getLocalWindow());
        }

        public void close() {
        }

        public boolean isFinished() {
            try {
                return this.delegate.available() == -1;
            }
            catch (IOException e) {
                return false;
            }
        }

        public boolean isReady() {
            try {
                return this.delegate.available() != 0;
            }
            catch (IOException e) {
                return false;
            }
        }

        public void mark(int limit) {
            this.delegate.mark(limit);
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public int read(@Nonnull byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public void reset() throws IOException {
            this.delegate.reset();
        }

        public void setReadListener(@Nonnull SshReadListener readListener) {
            this.readListener = Objects.requireNonNull(readListener, "readListener");
            if (this.isReady()) {
                readListener.onDataAvailable();
            }
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        void eof() {
            this.delegate.eof();
            this.fireOnDataAvailable();
        }

        void receive(byte[] bytes, int off, int len) throws IOException {
            this.delegate.receive(bytes, off, len);
            this.fireOnDataAvailable();
        }

        private void fireOnDataAvailable() {
            if (this.readListener == null) {
                return;
            }
            MDC.put((String)"a-protocol", (String)this.requestMetadata.getProtocol());
            MDC.put((String)"a-remote-address", (String)this.requestMetadata.getRemoteAddress());
            MDC.put((String)"a-request-action", (String)this.requestMetadata.getAction());
            MDC.put((String)"a-request-details", (String)this.requestMetadata.getDetails());
            MDC.put((String)"a-session-id", (String)this.requestMetadata.getSessionId());
            try {
                this.readListener.onDataAvailable();
            }
            catch (Exception e) {
                log.warn("Failed to notify listener", (Throwable)e);
            }
            finally {
                MDC.clear();
            }
        }
    }
}

