/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriter;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlingPacketWriter
implements ChannelStreamWriter {
    private static final Logger log = LoggerFactory.getLogger(ThrottlingPacketWriter.class);
    private final Channel channel;
    private final Semaphore semaphore;
    private final int totalPermits;
    private volatile boolean closed;

    public ThrottlingPacketWriter(Channel channel, final Semaphore semaphore) {
        this.channel = channel;
        this.semaphore = semaphore;
        this.closed = false;
        this.totalPermits = semaphore.availablePermits();
        channel.addChannelListener(new ChannelListener(){

            @Override
            public void channelClosed(Channel channel, Throwable reason) {
                ThrottlingPacketWriter.this.closed = true;
                int held = ThrottlingPacketWriter.this.totalPermits - semaphore.availablePermits();
                if (held > 0) {
                    semaphore.release(held);
                    log.trace("Released {} tickets from semaphore", (Object)held);
                }
            }
        });
    }

    @Override
    public IoWriteFuture writeData(Buffer buffer) throws IOException {
        if (this.closed) {
            return this.channel.writePacket(buffer);
        }
        this.semaphore.acquireUninterruptibly();
        if (this.closed) {
            this.semaphore.release();
            return this.channel.writePacket(buffer);
        }
        return this.channel.writePacket(buffer).addListener(f -> this.semaphore.release());
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

