/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.service;

import com.atlassian.bitbucket.dmz.ssh.DmzPublicKeyCodec;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import jakarta.annotation.Nonnull;
import java.security.PublicKey;
import java.util.Objects;

public class DefaultPublicKeyCodec
implements DmzPublicKeyCodec {
    @Nonnull
    public String calculateFingerprint(@Nonnull PublicKey key) {
        return KeyUtils.calculateFingerprint(Objects.requireNonNull(key, "key"));
    }

    @Nonnull
    public PublicKey decode(@Nonnull String keyText) {
        return KeyUtils.getPublicKey(Objects.requireNonNull(keyText, "keyText"));
    }

    @Nonnull
    public PublicKey decodeX509Key(@Nonnull String keyText, @Nonnull String algorithm) {
        return KeyUtils.getX509PublicKey(Objects.requireNonNull(keyText, "keyText"), Objects.requireNonNull(algorithm, "algorithm"));
    }

    @Nonnull
    public String encode(@Nonnull PublicKey key) {
        return KeyUtils.getKeyText(Objects.requireNonNull(key, "key"));
    }
}

