/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.service;

import com.atlassian.activeobjects.spi.TransactionSynchronisationManager;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.internal.ssh.dao.SshConfigurationDao;
import com.atlassian.bitbucket.internal.ssh.server.HostKeyPairProvider;
import com.atlassian.bitbucket.internal.ssh.service.SshBaseUrlResolver;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.ssh.SimpleSshConfiguration;
import com.atlassian.bitbucket.ssh.SimpleSshKeyFingerprint;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.SshKeyFingerprint;
import com.atlassian.bitbucket.ssh.event.SshConfigurationChangedEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import jakarta.validation.Validator;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSshConfigurationService
implements SshConfigurationService,
SshBaseUrlResolver,
LifecycleAware {
    static final int DEFAULT_PORT = 7999;
    static final String PLUGIN_PROPERTY_SSH_BASEURL = "plugin.ssh.baseurl";
    static final String SYS_PROP_PORT_OVERRIDE = "plugin.ssh.port";
    static final String TOPIC_SSH_CONFIG = "ssh.configuration";
    private static final Logger log = LoggerFactory.getLogger(SshConfigurationService.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final EventPublisher eventPublisher;
    private final HostKeyPairProvider hostKeyPairProvider;
    private final NavBuilder navBuilder;
    private final PermissionValidationService permissionValidationService;
    private final SshConfigurationDao sshConfigurationDao;
    private final Topic<String> topic;
    private final TransactionTemplate transactionTemplate;
    private final TransactionSynchronisationManager transactionSynchronisationManager;
    private final Validator validator;
    private String subscriptionId;
    private volatile SshConfiguration configuration;

    public DefaultSshConfigurationService(ApplicationPropertiesService applicationPropertiesService, EventPublisher eventPublisher, HostKeyPairProvider hostKeyPairProvider, NavBuilder navBuilder, PermissionValidationService permissionValidationService, SshConfigurationDao sshConfigurationDao, TransactionTemplate transactionTemplate, TransactionSynchronisationManager transactionSynchronisationManager, TopicService topicService, Validator validator) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.eventPublisher = eventPublisher;
        this.hostKeyPairProvider = hostKeyPairProvider;
        this.navBuilder = navBuilder;
        this.permissionValidationService = permissionValidationService;
        this.sshConfigurationDao = sshConfigurationDao;
        this.transactionTemplate = transactionTemplate;
        this.transactionSynchronisationManager = transactionSynchronisationManager;
        this.validator = validator;
        this.topic = topicService.getTopic(TOPIC_SSH_CONFIG, new TopicSettings.Builder(String.class).dedupePendingMessages(true).build());
        this.subscriptionId = this.topic.subscribe(message -> {
            if (!message.getSource().isLocal()) {
                log.debug("Received SSH configuration reload trigger from node {}", (Object)message.getSource().getAddress());
                SshConfiguration oldConfig = this.getConfiguration();
                this.loadConfiguration(true);
                SshConfiguration newConfiguration = this.getConfiguration();
                if (!Objects.equals(oldConfig, newConfiguration)) {
                    this.eventPublisher.publish((Object)new SshConfigurationChangedEvent(this, oldConfig, newConfiguration));
                }
            }
        });
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        SshConfiguration cfg = this.getConfiguration();
        String baseUrl = cfg.getBaseUrl();
        if (baseUrl == null) {
            baseUrl = this.getDefaultBaseUrl();
        }
        return baseUrl;
    }

    @Override
    @Nonnull
    public SshConfiguration getConfiguration() {
        SshConfiguration result = this.configuration;
        while (result == null) {
            this.loadConfiguration(false);
            result = this.configuration;
        }
        return result;
    }

    @Override
    @Nonnull
    public String getDefaultBaseUrl() {
        try {
            String host = new URI(this.navBuilder.buildBaseUrl()).getHost();
            return String.format("ssh://%s:%s", host, this.getConfiguration().getPort());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Base URL is not a valid URI");
        }
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent event) {
        if (event.isMaybeNetworkPartitionResolved()) {
            this.loadConfiguration(true);
        }
    }

    @Override
    public void setConfiguration(@Nonnull SshConfiguration newConfiguration) {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        ValidationUtils.validate((Validator)this.validator, (Object)newConfiguration, (Class[])new Class[0]);
        this.transactionTemplate.execute(() -> {
            SshConfiguration oldConfiguration = this.getConfiguration();
            if (!Objects.equals(oldConfiguration, newConfiguration)) {
                this.sshConfigurationDao.setConfiguration(newConfiguration);
                this.transactionSynchronisationManager.runOnSuccessfulCommit(() -> {
                    this.configuration = newConfiguration;
                    this.eventPublisher.publish((Object)new SshConfigurationChangedEvent(this, oldConfiguration, newConfiguration));
                    log.debug("Notifying other nodes of configuration change");
                    this.topic.publish((Serializable)((Object)"reload-config"));
                });
            }
            return null;
        });
    }

    @Override
    @Nonnull
    public SshKeyFingerprint getServerFingerprint() {
        return new SimpleSshKeyFingerprint(this.hostKeyPairProvider.getAlgorithm(), this.hostKeyPairProvider.getFingerprint());
    }

    public void onStart() {
        this.loadConfiguration(false);
    }

    public void onStop() {
        if (this.subscriptionId != null) {
            this.topic.unsubscribe(this.subscriptionId);
        }
        this.subscriptionId = null;
    }

    private String getSshBaseUrlFromProperties() {
        return this.applicationPropertiesService.getPluginProperty(PLUGIN_PROPERTY_SSH_BASEURL);
    }

    private int getSshPortFromProperties() {
        String sshPort = this.applicationPropertiesService.getPluginProperty(SYS_PROP_PORT_OVERRIDE);
        if (sshPort != null) {
            try {
                return Integer.parseInt(sshPort);
            }
            catch (NumberFormatException e) {
                log.warn("Override {} value [{}] is not valid, ignoring", new Object[]{SYS_PROP_PORT_OVERRIDE, sshPort, e});
            }
        }
        return 7999;
    }

    private void checkIfLoadedConfigurationOverrideValuesUsed() {
        int sshPortFromProperties;
        int configurationPort;
        String configurationBaseUrl = this.configuration.getBaseUrl();
        String sshBaseUrlFromProperties = this.getSshBaseUrlFromProperties();
        if (StringUtils.isNotBlank((CharSequence)configurationBaseUrl) && !configurationBaseUrl.equalsIgnoreCase(sshBaseUrlFromProperties)) {
            log.warn("Application configuration property '{}' is not used because its value has been configured in the Server settings", (Object)PLUGIN_PROPERTY_SSH_BASEURL);
        }
        if ((configurationPort = this.configuration.getPort()) != (sshPortFromProperties = this.getSshPortFromProperties())) {
            log.warn("Application configuration property '{}' is not used because its value has been configured in the Server settings", (Object)SYS_PROP_PORT_OVERRIDE);
        }
    }

    private synchronized boolean loadConfiguration(boolean reload) {
        SshConfiguration conf = this.configuration;
        if (conf != null && !reload) {
            return false;
        }
        this.configuration = this.sshConfigurationDao.getConfiguration().orElseGet(() -> new SimpleSshConfiguration(true, true, this.getSshPortFromProperties(), this.getSshBaseUrlFromProperties()));
        this.checkIfLoadedConfigurationOverrideValuesUsed();
        return true;
    }
}

