/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.service;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.dao.AoSshKeyTypeRestriction;
import com.atlassian.bitbucket.internal.ssh.dao.SshKeyTypeRestrictionDao;
import com.atlassian.bitbucket.internal.ssh.event.SshKeysGlobalExpiryChangedEvent;
import com.atlassian.bitbucket.internal.ssh.event.SshKeysTypeRestrictionMinLengthChangedEvent;
import com.atlassian.bitbucket.internal.ssh.service.InternalSshKeySettingsService;
import com.atlassian.bitbucket.internal.ssh.service.SshSupportedKeyTypesProvider;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.ssh.SimpleSshKeyType;
import com.atlassian.bitbucket.ssh.SimpleSshKeyTypeRestriction;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.SshKeyType;
import com.atlassian.bitbucket.ssh.SshKeyTypeRestriction;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;

public class DefaultSshKeySettingsService
implements InternalSshKeySettingsService {
    @VisibleForTesting
    static final String FALLBACK_CREATED_DATE = "fallbackCreatedDate";
    @VisibleForTesting
    static final String INVALID_EXPIRY_I18N_KEY = "bitbucket.rest.ssh.keys.error.admin.expiry";
    @VisibleForTesting
    static final String MAX_EXPIRY_DAYS = "maxExpiryDays";
    @VisibleForTesting
    static final String SSH_KEYS_SETTINGS_KEY = "com.atlassian.bitbucket.server.bitbucket-ssh-keys";
    private final Clock clock;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final PluginSettings pluginSettings;
    private final SshKeyTypeRestrictionDao sshKeyTypeRestrictionDao;
    private final Map<String, List<Integer>> sshSupportedKeyTypes;
    private final SshSupportedKeyTypesProvider sshSupportedKeyTypesProvider;
    private final TransactionTemplate transactionTemplate;

    public DefaultSshKeySettingsService(Clock clock, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, PluginSettingsFactory pluginSettingsFactory, SshKeyTypeRestrictionDao sshKeyTypeRestrictionDao, SshSupportedKeyTypesProvider sshSupportedKeyTypesProvider, TransactionTemplate transactionTemplate) {
        this.clock = clock;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.sshKeyTypeRestrictionDao = sshKeyTypeRestrictionDao;
        this.sshSupportedKeyTypesProvider = sshSupportedKeyTypesProvider;
        this.transactionTemplate = transactionTemplate;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(SSH_KEYS_SETTINGS_KEY);
        this.sshSupportedKeyTypes = sshSupportedKeyTypesProvider.getSupportedKeyLengthsByType();
    }

    @Override
    public Date getFallbackCreatedDate() {
        String date = (String)this.pluginSettings.get(FALLBACK_CREATED_DATE);
        return date == null ? null : new Date(Long.parseLong(date));
    }

    @Override
    @Nonnull
    public Optional<Integer> getRemainingDaysToExpiry(@Nonnull SshKey sshKey) {
        Objects.requireNonNull(sshKey, "sshKey");
        return Optional.ofNullable(sshKey.getCreatedDate()).flatMap(createdDate -> this.getExpiryDays(sshKey).map(expiryDays -> Math.toIntExact((long)expiryDays.intValue() - Duration.between(createdDate.toInstant(), this.clock.instant()).toDays())));
    }

    @Override
    public boolean meetsMinimumRestrictions(@Nonnull PublicKey publicKey) {
        Objects.requireNonNull(publicKey, "publicKey");
        return this.getKeyTypeRestriction(publicKey).map(SshKeyTypeRestriction::getMinKeyLength).map(minKeyLength -> KeyUtils.calculateKeyLength(publicKey) >= minKeyLength).orElse(false);
    }

    @Override
    @Nonnull
    public Optional<Integer> getExpiryDays(@Nonnull SshKey sshKey) {
        Objects.requireNonNull(sshKey, "sshKey");
        return Arrays.stream(new Integer[]{sshKey.getExpiryDays(), this.getGlobalMaxExpiryDaysInternal()}).filter(Objects::nonNull).min(Integer::compare);
    }

    @Override
    @Nonnull
    public List<SshKeyTypeRestriction> getKeyTypeRestrictions() {
        return (List)this.transactionTemplate.execute(() -> {
            List<AoSshKeyTypeRestriction> aoSshKeyTypeRestrictions = this.sshKeyTypeRestrictionDao.getAll();
            return (List)aoSshKeyTypeRestrictions.stream().map(aoSshKeyTypeRestriction -> new SimpleSshKeyTypeRestriction(aoSshKeyTypeRestriction.getAlgorithm(), aoSshKeyTypeRestriction.getMinKeyLength())).collect(MoreCollectors.toImmutableList());
        });
    }

    @Override
    @Nullable
    public Integer getMaxExpiry() {
        return this.getGlobalMaxExpiryDaysInternal();
    }

    @Override
    @Nonnull
    public List<SshKeyType> getSupportedKeyTypes() {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        ImmutableList.Builder supportedKeyTypes = new ImmutableList.Builder();
        this.sshSupportedKeyTypes.forEach((algorithm, keyLengths) -> supportedKeyTypes.add((Object)new SimpleSshKeyType((String)algorithm, (List<Integer>)keyLengths)));
        return supportedKeyTypes.build();
    }

    @Override
    public boolean hasExpired(@Nonnull SshKey sshKey) {
        Objects.requireNonNull(sshKey, "sshKey");
        return sshKey.getCreatedDate() != null && this.getExpiryDays(sshKey).map(expiryDays -> DateUtils.addDays((Date)sshKey.getCreatedDate(), (int)expiryDays).before(this.today())).orElse(false) != false;
    }

    @Override
    public void removeMaxExpiry() {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        Integer previousExpiry = this.getMaxExpiry();
        if (previousExpiry != null) {
            this.pluginSettings.remove(MAX_EXPIRY_DAYS);
            this.eventPublisher.publish((Object)new SshKeysGlobalExpiryChangedEvent(this, previousExpiry, null));
        }
    }

    @Override
    public void updateKeyTypeRestrictions(@Nonnull List<SshKeyTypeRestriction> newKeyTypeRestrictions) {
        Objects.requireNonNull(newKeyTypeRestrictions, "newKeyTypeRestrictions");
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        if (newKeyTypeRestrictions.isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.ssh.keys.error.admin.keyalgorithm", new Object[]{""}));
        }
        Map<String, List<Integer>> supportedKeyLengthsByType = this.sshSupportedKeyTypesProvider.getSupportedKeyLengthsByType();
        Sets.SetView unsupportedAlgorithms = Sets.difference(newKeyTypeRestrictions.stream().map(SshKeyTypeRestriction::getAlgorithm).collect(Collectors.toSet()), supportedKeyLengthsByType.keySet());
        if (!unsupportedAlgorithms.isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.ssh.keys.error.admin.keyalgorithm", new Object[]{String.join((CharSequence)",", (Iterable<? extends CharSequence>)unsupportedAlgorithms)}));
        }
        this.transactionTemplate.execute(() -> {
            for (SshKeyTypeRestriction restriction : newKeyTypeRestrictions) {
                Integer oldMinKeyLength;
                String algorithm = restriction.getAlgorithm();
                AoSshKeyTypeRestriction currentRestriction = this.sshKeyTypeRestrictionDao.getByAlgorithm(algorithm);
                if (currentRestriction == null) {
                    throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.ssh.keys.error.admin.keyalgorithm", new Object[]{algorithm}));
                }
                Integer newMinKeyLength = restriction.getMinKeyLength();
                if (Objects.equals(newMinKeyLength, oldMinKeyLength = currentRestriction.getMinKeyLength())) continue;
                if (newMinKeyLength != null && !((List)supportedKeyLengthsByType.get(algorithm)).contains(newMinKeyLength)) {
                    throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.ssh.keys.error.admin.keylength", new Object[]{newMinKeyLength, algorithm}));
                }
                this.sshKeyTypeRestrictionDao.update(currentRestriction, newMinKeyLength);
                this.eventPublisher.publish((Object)new SshKeysTypeRestrictionMinLengthChangedEvent(this, algorithm, oldMinKeyLength, newMinKeyLength));
            }
            return null;
        });
    }

    @Override
    public void upsertMaxExpiry(int expiryDays) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        if (expiryDays <= 0) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage(INVALID_EXPIRY_I18N_KEY, new Object[0]));
        }
        Integer existingExpiry = this.getMaxExpiry();
        if (!Objects.equals(existingExpiry, expiryDays)) {
            this.pluginSettings.put(MAX_EXPIRY_DAYS, (Object)String.valueOf(expiryDays));
            this.eventPublisher.publish((Object)new SshKeysGlobalExpiryChangedEvent(this, existingExpiry, expiryDays));
        }
        if (this.getFallbackCreatedDate() == null) {
            this.maybeSetFallbackCreatedDate(this.clock.instant());
        }
    }

    @Nullable
    private Integer getGlobalMaxExpiryDaysInternal() {
        String expiryDaysString = (String)this.pluginSettings.get(MAX_EXPIRY_DAYS);
        return expiryDaysString == null ? null : Integer.valueOf(expiryDaysString);
    }

    private Optional<SshKeyTypeRestriction> getKeyTypeRestriction(@Nonnull PublicKey publicKey) {
        Objects.requireNonNull(publicKey, "publicKey");
        return Optional.ofNullable(this.sshKeyTypeRestrictionDao.getByAlgorithm(KeyUtils.getKeyAlgorithm(publicKey)));
    }

    private void maybeSetFallbackCreatedDate(Instant instant) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        if (this.pluginSettings.get(FALLBACK_CREATED_DATE) == null) {
            this.pluginSettings.put(FALLBACK_CREATED_DATE, (Object)Long.toString(instant.toEpochMilli()));
        }
    }

    @Nonnull
    private Date today() {
        return new Date(this.clock.instant().toEpochMilli());
    }
}

