/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.service;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.springframework.stereotype.Component;

@Component(value="sshSupportedKeyTypesProvider")
public class SshSupportedKeyTypesProvider {
    private final Map<String, List<Integer>> supportedKeyLengthsByType;

    public SshSupportedKeyTypesProvider(@Nonnull ApplicationPropertiesService propertiesService) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int sshdMinDhGexKeySize = propertiesService.getPluginProperty("plugin.ssh.dhgex-keysize.min", 1024);
        int sshdMaxDhGexKeySize = SecurityUtils.getMaxDHGroupExchangeKeySize();
        ArrayList<Integer> rsaKeySizes = new ArrayList<Integer>();
        for (int i = sshdMinDhGexKeySize; i <= sshdMaxDhGexKeySize; i += 1024) {
            rsaKeySizes.add(i);
        }
        builder.put((Object)"RSA", rsaKeySizes);
        builder.put((Object)"DSA", (Object)ImmutableList.of((Object)1024)).put((Object)"ECDSA", (Object)ImmutableList.of((Object)256, (Object)384, (Object)521)).put((Object)"ED25519", (Object)ImmutableList.of((Object)256)).put((Object)"ECDSA-SK", (Object)ImmutableList.of((Object)256)).put((Object)"ED25519-SK", (Object)ImmutableList.of((Object)256));
        this.supportedKeyLengthsByType = builder.build();
    }

    public Map<String, List<Integer>> getSupportedKeyLengthsByType() {
        return ImmutableMap.copyOf(this.supportedKeyLengthsByType);
    }
}

