/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.servlet;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.ssh.servlet.ResponseRenderer;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SoyResponseRenderer
implements ResponseRenderer {
    private final AuthenticationContext authContext;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final XsrfTokenAccessor xsrfTokenAccessor;
    private final XsrfTokenValidator xsrfTokenValidator;

    public SoyResponseRenderer(AuthenticationContext authContext, SoyTemplateRenderer soyTemplateRenderer, XsrfTokenAccessor xsrfTokenAccessor, XsrfTokenValidator xsrfTokenValidator) {
        this.authContext = authContext;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.xsrfTokenAccessor = xsrfTokenAccessor;
        this.xsrfTokenValidator = xsrfTokenValidator;
    }

    @Override
    public void renderToResponse(HttpServletRequest req, HttpServletResponse resp, String completeModuleKey, String templateName, Map<String, Object> model) throws IOException, ServletException {
        resp.setContentType("text/html;charset=UTF-8");
        this.addXFrameHeader(resp);
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), completeModuleKey, templateName, model, this.getInjectedData(req, resp));
        }
        catch (SoyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException((Throwable)e);
        }
    }

    private Map<String, Object> getInjectedData(HttpServletRequest req, HttpServletResponse resp) {
        HashMap<String, Object> injectedData = new HashMap<String, Object>();
        injectedData.put("xsrfTokenName", this.xsrfTokenValidator.getXsrfParameterName());
        injectedData.put("xsrfTokenValue", this.xsrfTokenAccessor.getXsrfToken(req, resp, true));
        injectedData.put("principal", this.authContext.getCurrentUser());
        injectedData.put("productName", Product.NAME);
        return injectedData;
    }

    private void addXFrameHeader(HttpServletResponse resp) throws IOException {
        resp.setHeader("X-Frame-Options", "SAMEORIGIN");
    }
}

