/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.servlet;

import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import java.util.Date;
import java.util.LinkedHashMap;

class SshKeyForm
extends LinkedHashMap<String, Object> {
    static final String KEY_EXPIRY_DATE = "expiryDate";
    static final String KEY_EXPIRY_DAYS = "expiryDays";
    static final String KEY_LABEL = "label";
    static final String KEY_READ_ONLY = "readOnly";
    static final String KEY_TEXT = "text";
    static final String KEY_VERIFY = "verify";

    public SshKeyForm(Date expiryDate, Integer expiryDays, String keyLabel, String keyText, boolean readOnly, boolean verify) {
        String computedLabel;
        if (expiryDate != null) {
            this.put(KEY_EXPIRY_DATE, expiryDate);
        }
        if (keyText != null) {
            this.put(KEY_TEXT, keyText);
        }
        String string = computedLabel = keyLabel != null ? keyLabel : KeyUtils.getKeyComment(keyText);
        if (computedLabel != null) {
            this.put(KEY_LABEL, computedLabel);
        }
        if (expiryDays != null) {
            this.put(KEY_EXPIRY_DAYS, expiryDays);
        }
        this.put(KEY_VERIFY, verify);
        this.put(KEY_READ_ONLY, readOnly);
    }

    public Integer getExpiryDays() {
        return (Integer)this.get(KEY_EXPIRY_DAYS);
    }

    public String getLabel() {
        return (String)this.get(KEY_LABEL);
    }

    public String getText() {
        return (String)this.get(KEY_TEXT);
    }

    public boolean isReadOnly() {
        return Boolean.parseBoolean(String.valueOf(this.get(KEY_READ_ONLY)));
    }

    public boolean isVerify() {
        return Boolean.parseBoolean(String.valueOf(this.get(KEY_VERIFY)));
    }
}

