/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.servlet;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.RequestCanceledException;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.internal.ssh.service.InternalSshKeySettingsService;
import com.atlassian.bitbucket.internal.ssh.servlet.ResponseRenderer;
import com.atlassian.bitbucket.internal.ssh.servlet.SshKeyForm;
import com.atlassian.bitbucket.internal.ssh.servlet.SshKeysRequest;
import com.atlassian.bitbucket.internal.ssh.servlet.SshKeysRequestHandler;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.ssh.DuplicatePublicKeyException;
import com.atlassian.bitbucket.ssh.KeyType;
import com.atlassian.bitbucket.ssh.SetSshAccessKeyRequest;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshAccessKeyService;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

class SshKeyFormRequestHandler
implements SshKeysRequestHandler {
    static final String KEY_ASK_PERMISSION = "askPermission";
    static final String KEY_CANCEL_URL = "cancelUrl";
    static final String KEY_ID = "keyId";
    static final String KEY_IS_ADMIN_PAGE = "isAdminPage";
    static final String KEY_PROJECT = "project";
    static final String KEY_REPOSITORY = "repository";
    static final String KEY_USER = "user";
    @VisibleForTesting
    static final String TEMPLATE_ADD_KEY = "bitbucketPluginSsh.internal.views.pages.sshKeyForm.addKey";
    static final String TEMPLATE_EDIT_KEY = "bitbucketPluginSsh.internal.views.pages.sshKeyForm.editKey";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final SshAccessKeyService accessKeyService;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final PermissionService permissionService;
    private final ProjectSettingsRestrictionService projectSettingsRestrictionService;
    private final ResponseRenderer responseRenderer;
    private final SshConfigurationService sshConfigurationService;
    private final SshKeyService sshKeyService;
    private final InternalSshKeySettingsService sshKeySettingsService;
    private final EscalatedSecurityContext withAdmin;

    public SshKeyFormRequestHandler(I18nService i18nService, NavBuilder navBuilder, PermissionService permissionService, ProjectSettingsRestrictionService projectSettingsRestrictionService, ResponseRenderer responseRenderer, SecurityService securityService, SshConfigurationService sshConfigurationService, SshAccessKeyService accessKeyService, SshKeyService sshKeyService, InternalSshKeySettingsService sshKeySettingsService) {
        this.accessKeyService = accessKeyService;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.permissionService = permissionService;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
        this.responseRenderer = responseRenderer;
        this.sshConfigurationService = sshConfigurationService;
        this.sshKeyService = sshKeyService;
        this.sshKeySettingsService = sshKeySettingsService;
        this.withAdmin = securityService.withPermission(Permission.ADMIN, "For SSH access keys");
    }

    @Override
    public void get(SshKeysRequest request, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Project project;
        if (this.isDisabled(request)) {
            resp.sendError(409);
            return;
        }
        Map<String, Object> model = this.createModel(request);
        String template = TEMPLATE_ADD_KEY;
        if (request.isEdit()) {
            template = TEMPLATE_EDIT_KEY;
        }
        if (request.getRepository() != null && this.projectSettingsRestrictionService.hasRestriction(project = request.getRepository().getProject(), ProjectSettingsRestrictionKeys.ACCESS_KEYS) && !this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
            resp.sendError(401, this.i18nService.getMessage("bitbucket.settingsrestriction.ssh.key.restrictionexists.create", new Object[0]));
            return;
        }
        this.responseRenderer.renderToResponse(req, resp, "com.atlassian.stash.ssh-plugin:ssh-serverside-soy", template, model);
    }

    @Override
    public void post(SshKeysRequest request, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isDisabled(request)) {
            resp.sendError(409);
            return;
        }
        try {
            SshKeyForm keyForm = request.getForm();
            Project project = request.getProject();
            Repository repository = request.getRepository();
            if (keyForm.isVerify()) {
                this.verifyKey(keyForm, project == null && repository == null, resp);
                return;
            }
            SetSshAccessKeyRequest.Builder keyBuilder = new SetSshAccessKeyRequest.Builder();
            Integer keyId = request.isEdit() ? Integer.valueOf(Integer.parseInt(request.getKeyId())) : null;
            ApplicationUser user = request.getUser();
            String redirectUrl = Optional.ofNullable(project).map(p -> Optional.of(Scopes.project((Project)p))).orElseGet(() -> Optional.ofNullable(repository).map(Scopes::repository)).map(scope -> {
                Permission permission = request.getForm().isReadOnly() ? this.getReadPermission((Scope)scope) : this.getWritePermission((Scope)scope);
                boolean accessLevelUpdated = this.isAccessLevelUpdated(keyId, permission, (Scope)scope);
                this.addOrUpdateKey(request, keyId, keyForm, keyBuilder.scopeAccess((Scope)scope, permission), accessLevelUpdated, user);
                return this.getAccessKeysUrl((Scope)scope);
            }).orElseGet(() -> {
                if (user == null) {
                    throw new IllegalStateException("No project, repository or user identified by SshKeysRequest");
                }
                if (request.isEdit()) {
                    this.checkUserAuthorisedToUpdateKey(keyId);
                }
                this.addOrUpdateKey(request, keyId, keyForm, null, false, user);
                return this.getUserKeysUrl(user, request.isAdmin());
            });
            String nextUrl = request.getNextUrl();
            if (!StringUtils.isEmpty((CharSequence)nextUrl)) {
                redirectUrl = nextUrl;
            }
            resp.sendRedirect(UrlUtils.safeUrlForRedirect((String)redirectUrl, (String)this.navBuilder.buildAbsolute(), (String)this.navBuilder.buildAbsolute()));
        }
        catch (ConstraintViolationException e) {
            this.renderValidationErrors(request, req, resp, e.getConstraintViolations(), new String[0]);
        }
        catch (DuplicatePublicKeyException e) {
            this.renderValidationErrors(request, req, resp, null, e.getLocalizedMessage());
        }
        catch (NoSuchEntityException e) {
            resp.sendError(404, e.getLocalizedMessage());
        }
        catch (AuthorisationException | ForbiddenException e) {
            resp.sendError(401, e.getLocalizedMessage());
        }
        catch (RequestCanceledException e) {
            String[] cancelMessages = (String[])e.getCancelMessages().stream().map(KeyedMessage::getLocalisedMessage).toArray(String[]::new);
            this.renderValidationErrors(request, req, resp, null, cancelMessages);
        }
        catch (ArgumentValidationException e) {
            this.renderValidationErrors(request, req, resp, null, e.getLocalizedMessage());
        }
    }

    private void addOrUpdateKey(SshKeysRequest request, Integer keyId, SshKeyForm keyForm, SetSshAccessKeyRequest.Builder keyBuilder, boolean accessLevelUpdated, ApplicationUser user) {
        if (request.isEdit()) {
            this.setKeyLabel(keyId, keyForm);
            if (request.isForAccessKeys() && accessLevelUpdated) {
                this.withAdmin.call(() -> this.accessKeyService.set(keyBuilder.key(keyId).build()));
            }
        } else if (request.isForAccessKeys()) {
            this.withAdmin.call(() -> this.accessKeyService.set(keyBuilder.key(keyForm.getText(), keyForm.getLabel(), keyForm.getExpiryDays()).build()));
        } else {
            this.sshKeyService.addForUser(user, keyForm.getText(), keyForm.getLabel(), keyForm.getExpiryDays());
        }
    }

    private void checkUserAuthorisedToUpdateKey(Integer keyId) {
        this.sshKeyService.getById(keyId);
    }

    private Map<String, Object> createModel(SshKeysRequest request) {
        Project project;
        HashMap<String, Object> model = new HashMap<String, Object>();
        SshKeyForm form = request.getForm();
        if (form != null && !form.isEmpty()) {
            model.put("form", form);
        }
        if (request.isEdit()) {
            model.put(KEY_ID, request.getKeyId());
        }
        if (request.isAdmin()) {
            model.put(KEY_IS_ADMIN_PAGE, true);
        }
        if ((project = request.getProject()) != null) {
            model.put(KEY_PROJECT, project);
            model.put(KEY_ASK_PERMISSION, true);
            model.put(KEY_CANCEL_URL, this.getProjectAccessKeysUrl(project));
            return model;
        }
        Repository repository = request.getRepository();
        if (repository != null) {
            model.put(KEY_REPOSITORY, repository);
            model.put(KEY_ASK_PERMISSION, true);
            model.put(KEY_CANCEL_URL, this.getRepositoryAccessKeysUrl(repository));
            return model;
        }
        ApplicationUser user = request.getUser();
        if (user != null) {
            model.put(KEY_USER, user);
            model.put(KEY_ASK_PERMISSION, false);
            model.put(KEY_CANCEL_URL, this.getUserKeysUrl(user, request.isAdmin()));
            return model;
        }
        throw new IllegalStateException("No project, repository or user identified by SshKeysRequest");
    }

    private String getAccessKeysUrl(Scope scope) {
        return (String)scope.accept((ScopeVisitor)new ScopeVisitor<String>(){

            public String visit(@Nonnull ProjectScope scope) {
                return SshKeyFormRequestHandler.this.getProjectAccessKeysUrl(scope.getProject());
            }

            public String visit(@Nonnull RepositoryScope scope) {
                return SshKeyFormRequestHandler.this.getRepositoryAccessKeysUrl(scope.getRepository());
            }
        });
    }

    private String getProjectAccessKeysUrl(Project project) {
        return this.navBuilder.pluginServlets().path(new String[]{"ssh", "projects", project.getKey(), "keys"}).buildRelative();
    }

    private Permission getReadPermission(Scope scope) {
        return (Permission)scope.accept((ScopeVisitor)new ScopeVisitor<Permission>(this){

            public Permission visit(@Nonnull ProjectScope scope) {
                return Permission.PROJECT_READ;
            }

            public Permission visit(@Nonnull RepositoryScope scope) {
                return Permission.REPO_READ;
            }
        });
    }

    private String getRepositoryAccessKeysUrl(Repository repository) {
        return this.navBuilder.pluginServlets().path(new String[]{"ssh", "projects", repository.getProject().getKey(), "repos", repository.getSlug(), "keys"}).buildRelative();
    }

    private String getUserKeysUrl(ApplicationUser user, boolean admin) {
        if (admin) {
            return this.navBuilder.admin().users().view(user.getName()).listSshKeys().buildRelative();
        }
        return this.navBuilder.pluginServlets().path(new String[]{"ssh", "account", "keys"}).buildRelative();
    }

    private Permission getWritePermission(Scope scope) {
        return (Permission)scope.accept((ScopeVisitor)new ScopeVisitor<Permission>(this){

            public Permission visit(@Nonnull ProjectScope scope) {
                return Permission.PROJECT_WRITE;
            }

            public Permission visit(@Nonnull RepositoryScope scope) {
                return Permission.REPO_WRITE;
            }
        });
    }

    private boolean isAccessLevelUpdated(final Integer keyId, Permission permission, Scope scope) {
        if (keyId == null) {
            return false;
        }
        SshAccessKey sshAccessKey = (SshAccessKey)scope.accept((ScopeVisitor)new ScopeVisitor<SshAccessKey>(){

            public SshAccessKey visit(@Nonnull ProjectScope scope) {
                return SshKeyFormRequestHandler.this.accessKeyService.getByKeyAndProject(keyId, scope.getProject()).orElse(null);
            }

            public SshAccessKey visit(@Nonnull RepositoryScope scope) {
                return SshKeyFormRequestHandler.this.accessKeyService.getByKeyAndRepository(keyId, scope.getRepository()).orElse(null);
            }
        });
        return sshAccessKey != null ? permission != sshAccessKey.getPermission() : false;
    }

    private boolean isDisabled(SshKeysRequest request) {
        if (request.isForAccessKeys()) {
            SshConfiguration configuration = this.sshConfigurationService.getConfiguration();
            return !configuration.isEnabled() || !configuration.isAccessKeysEnabled();
        }
        return false;
    }

    private void renderValidationErrors(SshKeysRequest request, HttpServletRequest req, HttpServletResponse resp, Set<ConstraintViolation<?>> constraintViolations, String ... errorMessages) throws ServletException, IOException {
        Map<String, Object> model = this.createModel(request);
        if (constraintViolations != null) {
            model.put("fieldErrors", this.toFieldErrors(constraintViolations));
        }
        if (errorMessages != null) {
            model.put("formErrors", Arrays.asList(errorMessages));
        }
        this.responseRenderer.renderToResponse(req, resp, "com.atlassian.stash.ssh-plugin:ssh-serverside-soy", TEMPLATE_ADD_KEY, model);
    }

    private void setKeyLabel(int keyId, SshKeyForm keyForm) {
        this.withAdmin.call(() -> {
            this.sshKeyService.setKeyLabel(keyId, keyForm.getLabel());
            return null;
        });
    }

    private Map<String, List<String>> toFieldErrors(Set<ConstraintViolation<?>> constraintViolations) {
        if (constraintViolations == null) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (ConstraintViolation<?> constraintViolation : constraintViolations) {
            String key = constraintViolation.getPropertyPath().toString();
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(key)).add(constraintViolation.getMessage());
        }
        return map;
    }

    private void verifyKey(SshKeyForm keyForm, boolean personalKey, HttpServletResponse resp) throws IOException {
        if (personalKey) {
            resp.sendError(405);
            return;
        }
        try {
            PublicKey publicKey = KeyUtils.getPublicKey(keyForm.getText());
            SshKey sshKey = this.sshKeyService.getByPublicKey(publicKey);
            if (sshKey != null && sshKey.getType() == KeyType.ACCESS_KEY) {
                Date expiryDate = sshKey.getCreatedDate() == null ? null : (Date)this.sshKeySettingsService.getExpiryDays(sshKey).map(initialExpiryDays -> DateUtils.addDays((Date)sshKey.getCreatedDate(), (int)initialExpiryDays)).orElse(null);
                Integer remainingDaysToExpiry = this.sshKeySettingsService.getRemainingDaysToExpiry(sshKey).orElse(null);
                SshKeyForm responseKeyForm = new SshKeyForm(expiryDate, remainingDaysToExpiry, sshKey.getLabel(), sshKey.getText(), keyForm.isReadOnly(), keyForm.isVerify());
                resp.setContentType("application/json");
                String jsonForm = OBJECT_MAPPER.writeValueAsString((Object)responseKeyForm);
                resp.getWriter().println(jsonForm);
            } else {
                resp.sendError(404);
            }
        }
        catch (IllegalArgumentException e) {
            resp.sendError(400, e.getLocalizedMessage());
        }
    }
}

