/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.servlet;

import com.atlassian.bitbucket.internal.ssh.servlet.SshKeyForm;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;

class SshKeysRequest {
    private final boolean admin;
    private final SshKeyForm form;
    private final String keyId;
    private final String nextUrl;
    private final Project project;
    private final Repository repository;
    private final ApplicationUser user;

    public SshKeysRequest(boolean admin, SshKeyForm form, String keyId, String nextUrl, Project project, Repository repository, ApplicationUser user) {
        this.admin = admin;
        this.form = form;
        this.keyId = keyId;
        this.nextUrl = nextUrl;
        this.project = project;
        this.repository = repository;
        this.user = user;
    }

    public SshKeysRequest(boolean admin, SshKeyForm form, String nextUrl, Project project, Repository repository, ApplicationUser user) {
        this(admin, form, null, nextUrl, project, repository, user);
    }

    public SshKeyForm getForm() {
        return this.form;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getNextUrl() {
        return this.nextUrl;
    }

    public Project getProject() {
        return this.project;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isEdit() {
        return this.keyId != null;
    }

    public boolean isForAccessKeys() {
        return this.project != null || this.repository != null;
    }
}

