/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.utils;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamePreservingRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(NamePreservingRunnable.class);
    private final Runnable delegate;
    private final String newName;

    public NamePreservingRunnable(@Nonnull Runnable delegate, @Nonnull String newName) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.newName = Objects.requireNonNull(newName, "newName");
    }

    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        this.setName(currentThread, this.newName);
        try {
            this.delegate.run();
        }
        finally {
            this.setName(currentThread, oldName);
        }
    }

    private void setName(Thread thread, String name) {
        try {
            thread.setName(name);
        }
        catch (SecurityException e) {
            log.warn("Failed to set the thread name.", (Throwable)e);
        }
    }
}

