/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.who;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.ssh.who.WhoAmISshCommand;
import com.atlassian.bitbucket.ssh.command.SshCommand;
import com.atlassian.bitbucket.ssh.command.SshCommandContext;
import com.atlassian.bitbucket.ssh.command.SshCommandFactory;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class WhoAmISshCommandFactory
implements SshCommandFactory {
    private static final Set<String> SUPPORTED_COMMANDS = ImmutableSet.of((Object)"who am i", (Object)"whoami", (Object)"who");
    private final AuthenticationContext authenticationContext;

    public WhoAmISshCommandFactory(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @Nonnull
    public Optional<SshCommand> create(@Nonnull SshCommandContext context) {
        if (this.supports(context.getCommand())) {
            return Optional.of(new WhoAmISshCommand(this.authenticationContext, context.getStdout()));
        }
        return Optional.empty();
    }

    public boolean supports(@Nonnull String command) {
        return SUPPORTED_COMMANDS.contains(command.toLowerCase(Locale.ROOT));
    }
}

