/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ssh;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.EnumSet;
import java.util.Objects;

public class SetSshAccessKeyRequest {
    private final Integer keyExpiryDays;
    private final Integer keyId;
    private final String keyLabel;
    private final String keyText;
    private final Permission permission;
    private final Scope scope;

    private SetSshAccessKeyRequest(Builder builder) {
        this.keyExpiryDays = builder.keyExpiryDays;
        this.keyId = builder.keyId;
        this.keyLabel = builder.keyLabel;
        this.keyText = builder.keyText;
        this.permission = builder.permission;
        this.scope = builder.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetSshAccessKeyRequest that = (SetSshAccessKeyRequest)o;
        return Objects.equals(this.keyExpiryDays, that.keyExpiryDays) && Objects.equals(this.keyLabel, that.keyLabel) && Objects.equals(this.keyText, that.keyText) && Objects.equals(this.permission, that.permission) && Objects.equals(this.scope, that.scope);
    }

    public Integer getKeyExpiryDays() {
        return this.keyExpiryDays;
    }

    public Integer getKeyId() {
        return this.keyId;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public String getKeyText() {
        return this.keyText;
    }

    public Permission getPermission() {
        return this.permission;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    public int hashCode() {
        return Objects.hash(this.keyLabel, this.keyText, this.permission, this.scope);
    }

    public String toString() {
        return "SetAccessRequest{keyExpiryDays=" + this.keyExpiryDays + ", keyId=" + this.keyId + ", keyLabel='" + this.keyLabel + "', keyText='" + this.keyText + "', permission=" + String.valueOf(this.permission) + ", scope=" + String.valueOf(this.scope) + "}";
    }

    public static class Builder {
        private Integer keyExpiryDays;
        private Integer keyId;
        private String keyLabel;
        private String keyText;
        private Permission permission;
        private Scope scope;

        public SetSshAccessKeyRequest build() {
            Preconditions.checkState((this.permission == null || !this.permission.isGlobal() ? 1 : 0) != 0, (Object)"only resource permissions may be specified");
            return new SetSshAccessKeyRequest(this);
        }

        public Builder key(int id) {
            this.keyId = id;
            return this;
        }

        public Builder key(String keyText, String keyLabel) {
            this.keyLabel = keyLabel;
            this.keyText = keyText;
            return this;
        }

        public Builder key(String keyText, String keyLabel, Integer keyExpiryDays) {
            this.keyExpiryDays = keyExpiryDays;
            this.keyLabel = keyLabel;
            this.keyText = keyText;
            return this;
        }

        public Builder scopeAccess(@Nonnull Scope scope, @Nonnull Permission permission) {
            this.checkScopeAndPermission(Objects.requireNonNull(scope, "scope"), Objects.requireNonNull(permission, "permission"));
            this.permission = permission;
            this.scope = scope;
            return this;
        }

        private void checkScopeAndPermission(Scope scope, final Permission permission) {
            scope.accept((ScopeVisitor)new ScopeVisitor<Scope>(){

                public Scope visit(@Nonnull GlobalScope scope) {
                    throw new IllegalArgumentException("GlobalScope is not applicable for SshAccess keys");
                }

                public Scope visit(@Nonnull ProjectScope scope) {
                    Preconditions.checkArgument((boolean)EnumSet.of(Permission.PROJECT_READ, Permission.PROJECT_WRITE).contains(permission), (Object)"not a valid project permission");
                    return null;
                }

                public Scope visit(@Nonnull RepositoryScope scope) {
                    Preconditions.checkArgument((boolean)EnumSet.of(Permission.REPO_READ, Permission.REPO_WRITE).contains(permission), (Object)"not a valid repository permission");
                    return null;
                }
            });
        }
    }
}

