/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ssh;

import com.atlassian.bitbucket.ssh.SshKeyType;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class SimpleSshKeyType
implements SshKeyType {
    private final String algorithm;
    private final List<Integer> minKeyLengths;

    public SimpleSshKeyType(String algorithm, List<Integer> minKeyLengths) {
        this.algorithm = algorithm;
        this.minKeyLengths = ImmutableList.copyOf(minKeyLengths);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSshKeyType that = (SimpleSshKeyType)o;
        return Objects.equals(this.algorithm, that.algorithm) && this.minKeyLengths.equals(that.minKeyLengths);
    }

    @Override
    @Nonnull
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @Nonnull
    public List<Integer> getMinKeyLengths() {
        return this.minKeyLengths;
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, this.minKeyLengths);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("algorithm", (Object)this.algorithm).add("minKeyLengths", this.minKeyLengths).toString();
    }
}

