/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ssh;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.scope.Scope;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SshAccessKeySearchRequest {
    private final boolean effective;
    private final String labelPrefix;
    private final Permission minimumPermission;
    private final Scope scope;

    private SshAccessKeySearchRequest(Builder builder) {
        this.effective = builder.effective;
        this.labelPrefix = StringUtils.trimToEmpty((String)builder.labelPrefix);
        this.minimumPermission = Objects.requireNonNull(builder.minimumPermission, "minimumPermission");
        this.scope = builder.scope;
    }

    @Nonnull
    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    @Nonnull
    public Permission getMinimumPermission() {
        return this.minimumPermission;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    public boolean isEffective() {
        return this.effective;
    }

    public static class Builder {
        private boolean effective;
        private String labelPrefix;
        private Permission minimumPermission;
        private Scope scope;

        public Builder(Scope scope) {
            this.scope = scope;
        }

        public Builder(@Nonnull SshAccessKeySearchRequest sshAccessKeySearchRequest) {
            this.labelPrefix = Objects.requireNonNull(sshAccessKeySearchRequest, (String)"sshAccessKeySearchRequest").labelPrefix;
            this.scope = sshAccessKeySearchRequest.scope;
            this.effective = sshAccessKeySearchRequest.effective;
            this.minimumPermission = sshAccessKeySearchRequest.minimumPermission;
        }

        @Nonnull
        public SshAccessKeySearchRequest build() {
            return new SshAccessKeySearchRequest(this);
        }

        @Nonnull
        public Builder effective(boolean value) {
            this.effective = value;
            return this;
        }

        @Nonnull
        public Builder labelPrefix(@Nullable String value) {
            this.labelPrefix = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder minimumPermission(@Nonnull Permission value) {
            Objects.requireNonNull(value, "minimumPermission");
            Preconditions.checkArgument((boolean)value.isResource(), (Object)"Permission resource must be a Repository or Project");
            this.minimumPermission = value;
            return this;
        }
    }
}

