/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ssh;

import com.atlassian.bitbucket.ssh.KeyType;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.security.PublicKey;
import java.util.Date;

public interface SshKey {
    @Nullable
    public Date getCreatedDate();

    @Nullable
    @Max(value=999L, message="{com.atlassian.bitbucket.validation.invalid.expiry.message}")
    public @Max(value=999L, message="{com.atlassian.bitbucket.validation.invalid.expiry.message}") Integer getExpiryDays();

    @Nonnull
    public Integer getId();

    @Nullable
    @Size(max=255, message="{com.atlassian.bitbucket.validation.invalid.label.message}")
    public @Size(max=255, message="{com.atlassian.bitbucket.validation.invalid.label.message}") String getLabel();

    @Nullable
    public Date getLastAuthenticated();

    @NotNull(message="{com.atlassian.bitbucket.validation.required.publickey.message}")
    public @NotNull(message="{com.atlassian.bitbucket.validation.required.publickey.message}") String getText();

    @Nonnull
    public KeyType getType();

    @Nullable
    public ApplicationUser getUser();

    public boolean isRsaUnsafe();

    public boolean isUndecodable();

    @Nonnull
    public PublicKey toPublicKey();
}

