/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ssh;

import com.atlassian.bitbucket.ssh.Digest;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import jakarta.annotation.Nonnull;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.function.Function;

public enum StandardDigests implements Digest
{
    MD5(StandardDigests.builder().algorithm("MD5").format(arg_0 -> ((BaseEncoding)BaseEncoding.base16().lowerCase()).encode(arg_0)).build()),
    SHA256(StandardDigests.builder().algorithm("SHA256").format(arg_0 -> ((BaseEncoding)BaseEncoding.base64().omitPadding()).encode(arg_0)).build());

    private Digest digest;

    private StandardDigests(Digest digest) {
        this.digest = digest;
    }

    @Override
    @Nonnull
    public String apply(@Nonnull byte[] buffer) {
        return this.digest.apply(buffer);
    }

    @Nonnull
    private static Builder builder() {
        return new Builder();
    }

    private static class Builder {
        private String algorithm;
        private Function<byte[], String> format;

        private Builder() {
        }

        @Nonnull
        public Builder algorithm(@Nonnull String algorithm) {
            this.algorithm = Objects.requireNonNull(algorithm, "algorithm");
            return this;
        }

        @Nonnull
        public Builder format(@Nonnull Function<byte[], String> format) {
            this.format = Objects.requireNonNull(format, "format");
            return this;
        }

        @Nonnull
        public Digest build() {
            Objects.requireNonNull(this.algorithm, "algorithm");
            Objects.requireNonNull(this.format, "format");
            return buffer -> {
                Objects.requireNonNull(buffer, "buffer");
                try {
                    byte[] hash = MessageDigest.getInstance(this.algorithm).digest(buffer);
                    return this.format.apply(hash);
                }
                catch (NoSuchAlgorithmException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            };
        }
    }
}

