/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build;

import com.atlassian.bitbucket.build.status.BuildServer;
import com.atlassian.bitbucket.dmz.build.server.DmzBuildServerAuthorizationService;
import com.atlassian.bitbucket.dmz.build.server.DmzBuildServerAuthorizationStatus;
import com.atlassian.bitbucket.dmz.build.server.DmzBuildServerService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.SimpleBuildServerAuthorizationStatus;
import com.atlassian.bitbucket.internal.build.event.AnalyticsBuildAuthorizationRequestedEvent;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class DefaultBuildServerAuthorizationService
implements DmzBuildServerAuthorizationService {
    private final ApplicationPropertiesService applicationPropertiesService;
    private final DmzBuildServerService buildServerService;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final EventPublisher eventPublisher;

    public DefaultBuildServerAuthorizationService(ApplicationPropertiesService applicationPropertiesService, DmzBuildServerService buildServerService, I18nService i18nService, PermissionValidationService permissionValidationService, EventPublisher eventPublisher) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.buildServerService = buildServerService;
        this.eventPublisher = eventPublisher;
    }

    @Nonnull
    public DmzBuildServerAuthorizationStatus getAuthorizationStatus(@Nonnull String buildServerId) {
        BuildServer buildServer = this.getBuildServerOrThrow(buildServerId);
        boolean authorizationRequired = this.buildServerService.getBuildServerClient(buildServerId).isAuthorizationRequired();
        return new SimpleBuildServerAuthorizationStatus(buildServer, authorizationRequired);
    }

    @Nonnull
    public URI getAuthorizationUrl(@Nonnull String buildServerId, @Nonnull String relativeCallbackPath) {
        this.permissionValidationService.validateAuthenticated();
        Objects.requireNonNull(StringUtils.stripToNull((String)buildServerId), "buildServerId");
        if (URI.create(Objects.requireNonNull(relativeCallbackPath, "callback")).isAbsolute()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.server.auth.callback.absolute", new Object[0]));
        }
        URI baseUri = this.applicationPropertiesService.getBaseUrl();
        if (baseUri == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.server.auth.baseurl.invalid", new Object[0]));
        }
        URI absoluteCallback = DefaultBuildServerAuthorizationService.getAbsoluteCallback(baseUri, relativeCallbackPath);
        URI authorizationUrl = this.buildServerService.getBuildServerClient(buildServerId).getAuthorizationUrl(absoluteCallback);
        Optional buildServer = this.buildServerService.getBuildServer(buildServerId);
        this.eventPublisher.publish((Object)new AnalyticsBuildAuthorizationRequestedEvent(this, buildServer.orElse(null)));
        return authorizationUrl;
    }

    private static URI getAbsoluteCallback(URI baseUri, String relativeCallbackPath) {
        return URI.create(StringUtils.appendIfMissing((String)baseUri.toString(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + StringUtils.removeStart((String)relativeCallbackPath, (String)"/"));
    }

    private BuildServer getBuildServerOrThrow(String buildServerId) {
        return (BuildServer)this.buildServerService.getBuildServer(buildServerId).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.server.auth.serverid.none", new Object[]{buildServerId})));
    }
}

