/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build;

import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.build.server.operations.ActionResult;
import com.atlassian.bitbucket.build.server.operations.ActionState;
import com.atlassian.bitbucket.build.server.operations.BuildStatusAction;
import com.atlassian.bitbucket.build.status.BuildServer;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.dmz.build.BuildStatusOperationRequest;
import com.atlassian.bitbucket.dmz.build.BuildStatusOperationResponse;
import com.atlassian.bitbucket.dmz.build.operations.DmzBuildOperations;
import com.atlassian.bitbucket.dmz.build.operations.DmzBuildServerOperationsService;
import com.atlassian.bitbucket.dmz.build.server.BuildStatusClient;
import com.atlassian.bitbucket.dmz.build.server.DmzBuildServerService;
import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.SimpleActionResult;
import com.atlassian.bitbucket.internal.build.SimpleBuildAction;
import com.atlassian.bitbucket.internal.build.SimpleBuildOperations;
import com.atlassian.bitbucket.internal.build.SimpleBuildStatusOperationResponse;
import com.atlassian.bitbucket.internal.build.event.AnalyticsActionRejectedEvent;
import com.atlassian.bitbucket.internal.build.event.AnalyticsActionRequestedEvent;
import com.atlassian.bitbucket.internal.build.event.AnalyticsActionRunEvent;
import com.atlassian.bitbucket.internal.build.event.AnalyticsActionsLoadedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.concurrent.StateTransferringExecutorService;
import com.atlassian.stash.internal.concurrent.TransferableStateManager;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildServerOperationsService
implements DmzBuildServerOperationsService {
    static final String ACTIONS_ENABLED = "build.actions.enabled";
    static final long CACHE_EXPIRY = 5L;
    static final int MAX_ENTRIES = 5000;
    static final String PENDING_ACTIONS_MAX_ENTRIES = "build.actions.cache.max.pending";
    static final String PENDING_ACTIONS_TTL = "build.actions.cache.expiry";
    private static final Logger log = LoggerFactory.getLogger(DefaultBuildServerOperationsService.class);
    private final boolean actionsEnabled;
    private final AuthenticationContext authenticationContext;
    private final DmzBuildServerService buildServerService;
    private final DmzBuildStatusService buildStatusService;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final Cache<PendingActionCacheKey, PendingActionStatus> pendingActions;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;

    public DefaultBuildServerOperationsService(AuthenticationContext authenticationContext, InternalApplicationPropertiesService propertiesService, EventPublisher eventPublisher, CacheFactory cacheFactory, DmzBuildServerService buildServerService, DmzBuildStatusService buildStatusService, ExecutorService executorService, I18nService i18nService, PermissionService permissionService, PermissionValidationService permissionValidationService, TransferableStateManager stateManager) {
        this.authenticationContext = authenticationContext;
        this.buildServerService = buildServerService;
        this.buildStatusService = buildStatusService;
        this.eventPublisher = eventPublisher;
        this.executorService = new StateTransferringExecutorService(executorService, stateManager);
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.actionsEnabled = propertiesService.getProperty(ACTIONS_ENABLED, true);
        int maxEntries = propertiesService.getProperty(PENDING_ACTIONS_MAX_ENTRIES, 5000);
        long cacheExpiry = propertiesService.getProperty(PENDING_ACTIONS_TTL, 5L);
        this.pendingActions = cacheFactory.getCache(this.getClass().getName() + ".pendingActions", null, new CacheSettingsBuilder().remote().replicateAsynchronously().expireAfterWrite(cacheExpiry, TimeUnit.MINUTES).replicateViaCopy().maxEntries(maxEntries).build());
    }

    @Nonnull
    public Optional<DmzBuildOperations> getOperations(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String key) {
        if (!this.actionsEnabled) {
            return Optional.empty();
        }
        Objects.requireNonNull(StringUtils.stripToNull((String)key), "key");
        Objects.requireNonNull(repository, "repository");
        if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_WRITE)) {
            return Optional.empty();
        }
        if (!ShaUtils.isHash((String)commitId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.commit.idinvalid", new Object[0]));
        }
        RepositoryBuildStatus buildStatus = this.getBuildStatusOrThrow(repository, commitId, key);
        return this.buildServerService.getBuildStatusClient(buildStatus).map(buildStatusClient -> {
            DmzBuildOperations operations = new SimpleBuildOperations.Builder(buildStatusClient.getOperations()).pendingAction(this.internalGetPendingAction(buildStatus)).build();
            this.eventPublisher.publish((Object)new AnalyticsActionsLoadedEvent(this, operations.getActions().size(), operations.isAuthorizationRequired(), buildStatus, operations.getPendingAction().isPresent(), repository));
            return operations;
        });
    }

    public Optional<BuildStatusAction> getPendingAction(RepositoryBuildStatus buildStatus) {
        return Optional.ofNullable(this.internalGetPendingAction(buildStatus));
    }

    @Nonnull
    public BuildStatusOperationResponse performOperation(@Nonnull BuildStatusOperationRequest request) {
        Future<ActionResult> result;
        if (!this.actionsEnabled) {
            throw new FeatureDisabledException(this.i18nService.createKeyedMessage("bitbucket.build.operations.error.action.disabled", new Object[0]));
        }
        Objects.requireNonNull(request, "request");
        this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_WRITE);
        if (!ShaUtils.isHash((String)request.getCommitId())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.commit.idinvalid", new Object[0]));
        }
        RepositoryBuildStatus buildStatus = this.getBuildStatusOrThrow(request.getRepository(), request.getCommitId(), request.getBuildKey());
        BuildServer buildServer = this.getBuildServerOrThrow(buildStatus);
        PendingActionCacheKey pendingActionKey = new PendingActionCacheKey(buildStatus);
        BuildStatusClient buildStatusClient = this.getClientOrThrow(buildStatus);
        BuildStatusAction buildStatusAction = this.getActionOrThrow(request, buildStatusClient);
        PendingActionStatus thisAction = new PendingActionStatus(buildStatusAction);
        PendingActionStatus pendingAction = (PendingActionStatus)this.pendingActions.get((Object)pendingActionKey, () -> thisAction);
        if (pendingAction != thisAction) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.operations.error.action.pending", new Object[]{buildStatusAction.getName(), pendingAction.getActionName()}));
        }
        this.eventPublisher.publish((Object)new AnalyticsActionRequestedEvent(this, buildStatusAction.getId(), buildStatus, request.getRepository()));
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        try {
            result = this.executorService.submit(() -> {
                try {
                    ActionResult actionResult = buildStatusClient.performAction(buildStatusAction);
                    this.eventPublisher.publish((Object)new AnalyticsActionRunEvent(this, buildStatusAction.getId(), buildStatus, actionResult.getState(), request.getRepository()));
                    ActionResult actionResult2 = actionResult;
                    return actionResult2;
                }
                catch (Exception e) {
                    log.error("An exception occurred when performing the action '{}' on '{}'", new Object[]{buildStatusAction.getName(), buildServer.getName(), e});
                    this.eventPublisher.publish((Object)new AnalyticsActionRunEvent(this, buildStatusAction.getId(), buildStatus, ActionState.ERROR, request.getRepository()));
                    ActionResult actionResult = new SimpleActionResult.Builder(ActionState.ERROR).message(e.getLocalizedMessage()).build();
                    return actionResult;
                }
                finally {
                    this.pendingActions.remove((Object)pendingActionKey);
                }
            });
        }
        catch (RejectedExecutionException e) {
            log.error("The actions executor queue is full and is unable to schedule the requested action '{}' on '{}'", new Object[]{buildStatusAction.getName(), buildServer.getName(), e});
            this.eventPublisher.publish((Object)new AnalyticsActionRejectedEvent(this, buildStatusAction.getId(), buildStatus, request.getRepository()));
            result = CompletableFuture.completedFuture(new SimpleActionResult.Builder(ActionState.ERROR).message(this.i18nService.getMessage("bitbucket.build.operations.error.action.queue.full", new Object[0])).build());
            this.pendingActions.remove((Object)pendingActionKey);
        }
        return new SimpleBuildStatusOperationResponse(buildStatusAction, buildServer, result);
    }

    private BuildStatusAction getActionOrThrow(BuildStatusOperationRequest request, BuildStatusClient client) {
        return (BuildStatusAction)client.getAction(request.getActionId()).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.operations.error.action.invalid", new Object[]{request.getActionId()})));
    }

    private BuildServer getBuildServerOrThrow(RepositoryBuildStatus buildStatus) {
        return (BuildServer)buildStatus.getBuildServer().orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.operations.error.buildstatus.invalid", new Object[0])));
    }

    private RepositoryBuildStatus getBuildStatusOrThrow(Repository repository, String commitId, String key) {
        return (RepositoryBuildStatus)this.buildStatusService.get(repository, commitId, key).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.error.no.such.build.status", new Object[]{key, commitId, repository.getId()})));
    }

    private BuildStatusClient getClientOrThrow(RepositoryBuildStatus buildStatus) {
        return (BuildStatusClient)this.buildServerService.getBuildStatusClient(buildStatus).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.operations.error.buildstatus.invalid", new Object[0])));
    }

    @Nullable
    private BuildStatusAction internalGetPendingAction(RepositoryBuildStatus buildStatus) {
        PendingActionStatus pendingActionStatus = (PendingActionStatus)this.pendingActions.get((Object)new PendingActionCacheKey(buildStatus));
        if (pendingActionStatus == null) {
            return null;
        }
        String actionId = pendingActionStatus.getActionId();
        return ((BuildStatusClient)this.buildServerService.getBuildStatusClient(buildStatus).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.server.not.found", new Object[0])))).getAction(actionId).orElseGet(() -> new SimpleBuildAction(actionId, pendingActionStatus.getActionName()));
    }

    static class PendingActionStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String actionId;
        private final String actionName;

        PendingActionStatus(BuildStatusAction buildStatusAction) {
            this.actionId = buildStatusAction.getId();
            this.actionName = buildStatusAction.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PendingActionStatus that = (PendingActionStatus)o;
            return Objects.equals(this.actionId, that.actionId) && Objects.equals(this.actionName, that.actionName);
        }

        public String getActionId() {
            return this.actionId;
        }

        public String getActionName() {
            return this.actionName;
        }

        public int hashCode() {
            return Objects.hash(this.actionId, this.actionName);
        }

        public String toString() {
            return "PendingActionStatus{actionId='" + this.actionId + "'}";
        }
    }

    static class PendingActionCacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String buildKey;
        private final String commitId;
        private final int repositoryId;

        PendingActionCacheKey(RepositoryBuildStatus buildStatus) {
            this(buildStatus.getKey(), buildStatus.getRepository().getId(), buildStatus.getCommitId());
        }

        PendingActionCacheKey(String buildKey, int repositoryId, String commitId) {
            this.buildKey = buildKey;
            this.repositoryId = repositoryId;
            this.commitId = commitId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PendingActionCacheKey that = (PendingActionCacheKey)o;
            return this.repositoryId == that.repositoryId && Objects.equals(this.buildKey, that.buildKey) && Objects.equals(this.commitId, that.commitId);
        }

        public int hashCode() {
            return Objects.hash(this.buildKey, this.repositoryId, this.commitId);
        }

        public String toString() {
            return "PendingActionCacheKey{buildKey='" + this.buildKey + "', repositoryId=" + this.repositoryId + ", commitId='" + this.commitId + "'}";
        }
    }
}

