/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build;

import com.atlassian.bitbucket.build.server.PluginBuildServer;
import com.atlassian.bitbucket.build.server.PluginBuildServerProvider;
import com.atlassian.bitbucket.build.server.PluginBuildServerProviderModuleDescriptor;
import com.atlassian.bitbucket.build.status.BuildServer;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.dmz.build.server.BuildServerClient;
import com.atlassian.bitbucket.dmz.build.server.BuildStatusClient;
import com.atlassian.bitbucket.dmz.build.server.DmzBuildServerService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.SimpleBuildServer;
import com.atlassian.bitbucket.internal.build.SimpleBuildServerClient;
import com.atlassian.bitbucket.internal.build.SimpleBuildStatusClient;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.RequestLocalMap;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.plugin.PluginAccessor;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefaultBuildServerService
implements DmzBuildServerService {
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;
    private final RequestLocalMap<String, Optional<PluginBuildServer>> requestLocalCache;

    public DefaultBuildServerService(I18nService i18nService, PluginAccessor pluginAccessor, RequestManager requestManager) {
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
        this.requestLocalCache = new RequestLocalMap(requestManager);
    }

    @Nonnull
    public Optional<BuildServer> getBuildServer(@Nullable String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Optional.empty();
        }
        return this.getPluginBuildServer(id).map(DefaultBuildServerService::toBuildServer);
    }

    @Nonnull
    public Optional<BuildServer> getBuildServer(@Nonnull HttpServletRequest servletRequest, @Nonnull Map<String, Object> requestBody) {
        return this.getProviders().stream().flatMap(provider -> MoreStreams.streamOptional((Optional)provider.getBuildServer(servletRequest, requestBody))).map(DefaultBuildServerService::toBuildServer).findFirst();
    }

    @Nonnull
    public Optional<PluginBuildServer> getPluginBuildServer(@Nullable String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Optional.empty();
        }
        return (Optional)this.requestLocalCache.get((Object)id, () -> this.getProviders().stream().flatMap(provider -> MoreStreams.streamOptional((Optional)provider.getBuildServer(id))).findFirst());
    }

    @Nonnull
    public BuildServerClient getBuildServerClient(@Nonnull String buildServerId) {
        return this.getPluginBuildServer(buildServerId).map(pluginBuildServer -> new SimpleBuildServerClient(pluginBuildServer.getClient())).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.server.invalid", new Object[]{buildServerId})));
    }

    @Nonnull
    public Optional<BuildStatusClient> getBuildStatusClient(@Nonnull RepositoryBuildStatus buildStatus) {
        return buildStatus.getBuildServer().flatMap(buildServer -> this.getPluginBuildServer(buildServer.getId())).map(pluginBuildServer -> new SimpleBuildStatusClient(buildStatus, pluginBuildServer.getClient()));
    }

    private static BuildServer toBuildServer(PluginBuildServer pluginBuildServer) {
        return new SimpleBuildServer(pluginBuildServer);
    }

    private List<PluginBuildServerProvider> getProviders() {
        return ModuleDescriptorUtils.toModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(PluginBuildServerProviderModuleDescriptor.class)).collect(Collectors.toList());
    }
}

