/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build;

import com.atlassian.bitbucket.build.server.operations.BuildStatusAction;
import com.atlassian.bitbucket.dmz.build.operations.DmzBuildOperations;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SimpleBuildOperations
implements DmzBuildOperations {
    private final List<BuildStatusAction> buildStatusActions;
    private final boolean isAuthorizationRequired;
    private final BuildStatusAction pendingAction;

    private SimpleBuildOperations(Builder builder) {
        this.buildStatusActions = builder.buildActions.build();
        this.isAuthorizationRequired = builder.isAuthorizationRequired;
        this.pendingAction = builder.pendingAction;
    }

    @Nonnull
    public List<BuildStatusAction> getActions() {
        return this.buildStatusActions;
    }

    public boolean isAuthorizationRequired() {
        return this.isAuthorizationRequired;
    }

    public Optional<BuildStatusAction> getPendingAction() {
        return Optional.ofNullable(this.pendingAction);
    }

    public static final class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<BuildStatusAction> buildActions = ImmutableList.builder();
        private boolean isAuthorizationRequired;
        private BuildStatusAction pendingAction;

        public Builder() {
        }

        public Builder(DmzBuildOperations toCopy) {
            this.buildActions.addAll((Iterable)toCopy.getActions());
            this.isAuthorizationRequired = toCopy.isAuthorizationRequired();
            this.pendingAction = toCopy.getPendingAction().orElse(null);
        }

        @Nonnull
        public Builder action(@Nonnull BuildStatusAction value) {
            this.buildActions.add((Object)Objects.requireNonNull(value, "value"));
            return this;
        }

        @Nonnull
        public Builder actions(@Nonnull Collection<BuildStatusAction> values) {
            this.buildActions.addAll((Iterable)Objects.requireNonNull(values, "values"));
            return this;
        }

        @Nonnull
        public DmzBuildOperations build() {
            return new SimpleBuildOperations(this);
        }

        @Nonnull
        public Builder isAuthorizationRequired(boolean value) {
            this.isAuthorizationRequired = value;
            return this;
        }

        @Nonnull
        public Builder pendingAction(@Nullable BuildStatusAction value) {
            this.pendingAction = value;
            return this;
        }
    }
}

