/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build;

import com.atlassian.bitbucket.build.server.operations.ActionResult;
import com.atlassian.bitbucket.build.server.operations.BuildOperations;
import com.atlassian.bitbucket.build.server.operations.BuildStatusAction;
import com.atlassian.bitbucket.build.server.operations.BuildStatusActionRequest;
import com.atlassian.bitbucket.build.server.operations.PluginBuildServerClient;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.dmz.build.operations.DmzBuildOperations;
import com.atlassian.bitbucket.dmz.build.server.BuildStatusClient;
import com.atlassian.bitbucket.internal.build.SimpleBuildOperations;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class SimpleBuildStatusClient
implements BuildStatusClient {
    private final RepositoryBuildStatus buildStatus;
    private final PluginBuildServerClient delegate;

    public SimpleBuildStatusClient(@Nonnull RepositoryBuildStatus buildStatus, @Nonnull PluginBuildServerClient pluginBuildServerClient) {
        this.buildStatus = Objects.requireNonNull(buildStatus, "buildStatus");
        this.delegate = Objects.requireNonNull(pluginBuildServerClient, "pluginBuildServerClient");
    }

    @Nonnull
    public Optional<BuildStatusAction> getAction(@Nonnull String actionId) {
        return this.delegate.getAction(this.buildStatus, actionId);
    }

    @Nonnull
    public DmzBuildOperations getOperations() {
        BuildOperations operations = this.delegate.getOperations(this.buildStatus);
        return new SimpleBuildOperations.Builder().actions(operations.getActions()).isAuthorizationRequired(operations.isAuthorizationRequired()).build();
    }

    public ActionResult performAction(@Nonnull BuildStatusAction buildStatusAction) {
        return this.delegate.performAction(new BuildStatusActionRequest.Builder(buildStatusAction, this.buildStatus).build());
    }
}

