/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.event;

import com.atlassian.bitbucket.build.status.BuildServer;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.google.common.hash.Hashing;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public abstract class AbstractAnalyticsBuildServerEvent
extends ApplicationEvent {
    private final String buildServerId;
    private final String buildServerType;

    public AbstractAnalyticsBuildServerEvent(@Nonnull Object source, @Nullable BuildServer buildServer) {
        super(source);
        this.buildServerId = buildServer == null ? null : buildServer.getId();
        this.buildServerType = buildServer == null ? null : buildServer.getTypeId();
    }

    @Nullable
    public String getBuildServerId() {
        return this.buildServerId;
    }

    @Nullable
    public String getBuildServerIdHashed() {
        return AbstractAnalyticsBuildServerEvent.toUUID(this.buildServerId);
    }

    @Nullable
    public String getBuildServerType() {
        return this.buildServerType;
    }

    private static String toUUID(String input) {
        if (input == null) {
            return null;
        }
        return UUID.nameUUIDFromBytes(Hashing.sha256().hashString((CharSequence)input, StandardCharsets.UTF_8).asBytes()).toString();
    }
}

