/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.BuildServer;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatus;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.internal.build.event.AbstractAnalyticsBuildServerEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@AsynchronousPreferred
@EventName(value="stash.buildStatus.set")
@TransactionAware
public class AnalyticsBuildStatusSetEvent
extends AbstractAnalyticsBuildServerEvent {
    private final Repository repository;
    private final RepositoryBuildStatus buildStatus;
    private final LegacyBuildStatus legacyBuildStatus;

    private AnalyticsBuildStatusSetEvent(@Nonnull Object source, @Nullable RepositoryBuildStatus buildStatus, @Nullable LegacyBuildStatus legacyBuildStatus, @Nullable Repository repository) {
        super(source, buildStatus == null ? null : (BuildServer)buildStatus.getBuildServer().orElse(null));
        this.repository = repository;
        this.buildStatus = buildStatus;
        this.legacyBuildStatus = legacyBuildStatus;
    }

    public AnalyticsBuildStatusSetEvent(@Nonnull Object source, @Nullable RepositoryBuildStatus buildStatus, @Nullable Repository repository) {
        this(source, buildStatus, null, repository);
    }

    public AnalyticsBuildStatusSetEvent(@Nonnull Object source, @Nonnull RepositoryBuildStatus buildStatus) {
        this(source, buildStatus, null);
    }

    public AnalyticsBuildStatusSetEvent(@Nonnull Object source, @Nonnull LegacyBuildStatus legacyBuildStatus) {
        this(source, null, legacyBuildStatus, null);
    }

    @Nonnull
    public BuildState getBuildState() {
        if (this.legacyBuildStatus != null) {
            return this.legacyBuildStatus.getState();
        }
        return this.buildStatus.getState();
    }

    @Nullable
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public RepositoryBuildStatus getBuildStatus() {
        return this.buildStatus;
    }

    @Nullable
    public LegacyBuildStatus getLegacyBuildStatus() {
        return this.legacyBuildStatus;
    }
}

