/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status;

import com.atlassian.bitbucket.internal.build.status.model.InternalBuildStatus;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionTemplate;

public final class BuildStatusHelper {
    private static final Logger log = LoggerFactory.getLogger(BuildStatusHelper.class);
    private static final int MAX_SET_RETRIES = 2;

    private BuildStatusHelper() {
    }

    public static InternalBuildStatus createWithRetry(TransactionTemplate withNewTransaction, Supplier<InternalBuildStatus> createBuildStatus) {
        int attempt = 1;
        while (true) {
            try {
                return (InternalBuildStatus)withNewTransaction.execute(transactionStatus -> (InternalBuildStatus)createBuildStatus.get());
            }
            catch (Exception e) {
                if (attempt >= 2) {
                    throw e;
                }
                log.debug("Failed due to an exception. Retrying... (attempt {}/{})", new Object[]{attempt, 2, e});
                ++attempt;
                continue;
            }
            break;
        }
    }
}

