/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.server.PluginBuildServer;
import com.atlassian.bitbucket.build.status.AbstractBuildStatusSearchRequest;
import com.atlassian.bitbucket.build.status.BuildServer;
import com.atlassian.bitbucket.build.status.BuildStatusPullRequestSearchRequest;
import com.atlassian.bitbucket.build.status.BuildStatusRepositorySearchRequest;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusDeletedEvent;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetEvent;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.dmz.build.server.DmzBuildServerService;
import com.atlassian.bitbucket.dmz.build.status.AbstractBuildStatusSummaryRequest;
import com.atlassian.bitbucket.dmz.build.status.AbstractBulkCommitBuildStatusSummaryRequest;
import com.atlassian.bitbucket.dmz.build.status.BuildStatusParent;
import com.atlassian.bitbucket.dmz.build.status.BuildStatusParentSearchRequest;
import com.atlassian.bitbucket.dmz.build.status.BuildSummary;
import com.atlassian.bitbucket.dmz.build.status.BulkPullRequestBuildStatusSummaryRequest;
import com.atlassian.bitbucket.dmz.build.status.BulkRefBuildStatusSummaryRequest;
import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.dmz.build.status.PullRequestBulkCommitBuildStatusSummaryRequest;
import com.atlassian.bitbucket.dmz.build.status.RefBulkCommitBuildStatusSummaryRequest;
import com.atlassian.bitbucket.dmz.commit.DmzCommitEnricher;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.status.AnalyticsBuildStatusSetEvent;
import com.atlassian.bitbucket.internal.build.status.BuildStatusHelper;
import com.atlassian.bitbucket.internal.build.status.SimpleBuildStatus;
import com.atlassian.bitbucket.internal.build.status.SimpleBuildSummary;
import com.atlassian.bitbucket.internal.build.status.UntrustedBuildStatusException;
import com.atlassian.bitbucket.internal.build.status.dao.BuildCountForRef;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusBulkCommitSummaryCriteria;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusBulkRefSummaryCriteria;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusDao;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusSearchCriterion;
import com.atlassian.bitbucket.internal.build.status.model.InternalBuildStatus;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitsRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ResolveRefsRequest;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.bitbucket.util.UrlHrefUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Transactional(readOnly=true)
public class DefaultBuildStatusService
implements DmzBuildStatusService {
    private static final long DEFAULT_DAYS_SINCE_EARLIEST_CREATED_DATE = 30L;
    private static final int MAX_COMMIT_IDS = 1000;
    private static final int MAX_PAGE_SIZE = 500;
    private static final int MAX_PARENT_KEY_LENGTH = 255;
    private static final int MAX_REF_IDS = 1000;
    private static final Map<BuildState, Integer> emptySummary = new HashMap<BuildState, Integer>();
    private final DmzBuildServerService buildServerService;
    private final BuildStatusDao buildStatusDao;
    private final DmzCommitEnricher commitEnricher;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final InternalPullRequestService pullRequestService;
    private final RefService refService;
    private final boolean rejectUntrustedBuildStatus;
    private final ScmService scmService;
    private final TransactionTemplate transactionTemplate;

    public DefaultBuildStatusService(BuildStatusDao buildStatusDao, DmzBuildServerService buildServerService, DmzCommitEnricher commitEnricher, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, PlatformTransactionManager platformTransactionManager, InternalPullRequestService pullRequestService, RefService refService, boolean rejectUntrustedBuildStatus, ScmService scmService) {
        this(buildStatusDao, buildServerService, commitEnricher, eventPublisher, i18nService, permissionValidationService, pullRequestService, refService, rejectUntrustedBuildStatus, scmService, new TransactionTemplate(platformTransactionManager, SpringTransactionUtils.REQUIRES_NEW));
    }

    @VisibleForTesting
    DefaultBuildStatusService(BuildStatusDao buildStatusDao, DmzBuildServerService buildServerService, DmzCommitEnricher commitEnricher, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, InternalPullRequestService pullRequestService, RefService refService, boolean rejectUntrustedBuildStatus, ScmService scmService, TransactionTemplate transactionTemplate) {
        this.buildStatusDao = buildStatusDao;
        this.buildServerService = buildServerService;
        this.commitEnricher = commitEnricher;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.pullRequestService = pullRequestService;
        this.refService = refService;
        this.rejectUntrustedBuildStatus = rejectUntrustedBuildStatus;
        this.scmService = scmService;
        this.transactionTemplate = transactionTemplate;
    }

    @Nonnull
    public Optional<RepositoryBuildStatus> get(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String key) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(StringUtils.stripToNull((String)commitId), "commitId");
        Objects.requireNonNull(StringUtils.stripToNull((String)key), "key");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ);
        return this.buildStatusDao.get(repository.getId(), commitId, key).map(internalBuildStatus -> {
            Map<String, Commit> commitMap = this.getCommits(repository, null, Collections.singletonList(commitId));
            return this.convertBuildStatus(repository, (InternalBuildStatus)internalBuildStatus, commitMap);
        });
    }

    @Nonnull
    public Map<String, BuildSummary> getSummaries(@Nonnull RefBulkCommitBuildStatusSummaryRequest request) {
        Set<String> commitIds;
        this.validateBulkCommitSummaryRequest((AbstractBulkCommitBuildStatusSummaryRequest)request);
        Ref ref = request.getRef();
        if (ref == null && request.getCommitIds().isEmpty()) {
            ref = this.refService.getDefaultBranch(request.getRepository());
        }
        Set<String> set = commitIds = ref != null && request.getCommitIds().isEmpty() ? Collections.singleton(ref.getLatestCommit()) : request.getCommitIds();
        if (commitIds.isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.summary.request.empty", new Object[0]));
        }
        BuildStatusBulkCommitSummaryCriteria criteria = new BuildStatusBulkCommitSummaryCriteria.Builder().commitIds(commitIds).ref(ref == null ? null : ref.getId()).repositoryId(request.getRepository().getId()).build();
        try (Ticker ignored = Timers.timer((String)String.format("DefaultBuildStatusService: Getting build summaries for %s commits on ref %s", request.getCommitIds().size(), ref == null ? null : ref.getId())).start(new Object[]{request.getRepository().getId()});){
            Map<String, BuildSummary> map = DefaultBuildStatusService.collectSummaries(this.buildStatusDao.countByState(criteria));
            return map;
        }
    }

    @Nonnull
    public Map<Long, BuildSummary> getSummaries(@Nonnull BulkPullRequestBuildStatusSummaryRequest request) {
        this.validateSummaryRequest((AbstractBuildStatusSummaryRequest)request);
        if (request.getPullRequestIds().size() > 1000) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.prlist.toobig", new Object[]{1000}));
        }
        try (Ticker ignored = Timers.timer((String)String.format("DefaultBuildStatusService: Getting build summaries for %s pull requests", request.getPullRequestIds().size())).start(new Object[]{request.getRepository().getId()});){
            ImmutableMap immutableMap;
            block13: {
                Collection pullRequests = this.pullRequestService.getByIds(request.getRepository().getId(), request.getPullRequestIds());
                List<BuildCountForRef> counts = this.buildStatusDao.countByState(new BuildStatusBulkRefSummaryCriteria.Builder().commitIds(pullRequests.stream().map(pullRequest -> pullRequest.getFromRef().getLatestCommit()).collect(Collectors.toSet())).refs(pullRequests.stream().map(pullRequest -> pullRequest.getFromRef().getId()).collect(Collectors.toSet())).repositoryIds(pullRequests.stream().flatMap(pullRequest -> {
                    if (!pullRequest.isCrossRepository()) {
                        return Stream.of(Integer.valueOf(pullRequest.getToRef().getRepository().getId()));
                    }
                    return Stream.of(pullRequest.getToRef().getRepository().getId(), pullRequest.getFromRef().getRepository().getId());
                }).collect(Collectors.toSet())).build());
                Ticker ignored2 = Timers.timer((String)String.format("DefaultBuildStatusService: Post-processing of pull request summaries for %s build count rows", counts.size())).start(new Object[]{request.getRepository().getId()});
                try {
                    ImmutableListMultimap commitToPullRequest = Multimaps.index((Iterable)pullRequests, pullRequest -> pullRequest.getFromRef().getLatestCommit());
                    HashMap summaries = new HashMap();
                    counts.forEach(arg_0 -> DefaultBuildStatusService.lambda$getSummaries$9((Multimap)commitToPullRequest, summaries, arg_0));
                    immutableMap = ImmutableMap.copyOf((Map)Maps.transformValues(summaries, SimpleBuildSummary::new));
                    if (ignored2 == null) break block13;
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored2.close();
            }
            return immutableMap;
        }
    }

    @Nonnull
    public Map<Ref, BuildSummary> getSummaries(@Nonnull BulkRefBuildStatusSummaryRequest request) {
        this.validateSummaryRequest((AbstractBuildStatusSummaryRequest)request);
        if (request.getRefs().size() > 1000) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.reflist.toobig", new Object[]{1000}));
        }
        Map<String, Ref> resolvedRefs = this.resolveRefs(request.getRepository(), request.getRefs());
        return this.getBuildSummariesForRef(request.getRepository(), resolvedRefs);
    }

    @Nonnull
    public Map<String, BuildSummary> getSummaries(@Nonnull PullRequestBulkCommitBuildStatusSummaryRequest request) {
        this.validateBulkCommitSummaryRequest((AbstractBulkCommitBuildStatusSummaryRequest)request);
        Set<String> commitIds = request.getCommitIds().isEmpty() ? Collections.singleton(request.getPullRequest().getFromRef().getLatestCommit()) : request.getCommitIds();
        BuildStatusBulkCommitSummaryCriteria.Builder criterionBuilder = new BuildStatusBulkCommitSummaryCriteria.Builder().commitIds(commitIds).ref(request.getPullRequest().getFromRef().getId()).repositoryId(request.getRepository().getId());
        if (request.getPullRequest().isCrossRepository()) {
            criterionBuilder.additionalRepositoryId(request.getPullRequest().getFromRef().getRepository().getId());
        }
        try (Ticker ignored = Timers.timer((String)String.format("DefaultBuildStatusService: Getting build summaries for %s commits on pull request %s", request.getCommitIds().size(), request.getPullRequest().getId())).start(new Object[]{request.getRepository().getId()});){
            Map<String, BuildSummary> map = DefaultBuildStatusService.collectSummaries(this.buildStatusDao.countByState(criterionBuilder.build()));
            return map;
        }
    }

    public Map<Ref, BuildSummary> getSummaries(Repository repository, @Nonnull Collection<Ref> refs) {
        this.permissionValidationService.validateForRepository(Objects.requireNonNull(repository, "repository"), Permission.REPO_READ);
        if (refs.size() > 1000) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.reflist.toobig", new Object[]{1000}));
        }
        Map<String, Ref> resolvedRefs = refs.stream().collect(Collectors.toMap(MinimalRef::getId, ref -> ref));
        return this.getBuildSummariesForRef(repository, resolvedRefs);
    }

    @Nonnull
    public Page<BuildStatusParent> getBuildParents(@Nonnull BuildStatusParentSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(searchRequest, "searchRequest");
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.permissionValidationService.validateForRepository(searchRequest.getRepository(), Permission.REPO_READ);
        Date earliestCreatedDate = searchRequest.getSince().orElse(Date.from(Instant.now().minus(Duration.ofDays(30L))));
        if (earliestCreatedDate.after(Date.from(Instant.now()))) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.parent.futuredate", new Object[0]));
        }
        if (searchRequest.getFilter().length() > 255 || searchRequest.getFilter().length() <= 1) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.parent.badlength", new Object[0]));
        }
        return this.buildStatusDao.findMatchingParents(searchRequest.getRepository().getId(), searchRequest.getFilter(), earliestCreatedDate, pageRequest);
    }

    @Transactional
    public void remove(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String key) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(StringUtils.stripToNull((String)commitId), "commitId");
        Objects.requireNonNull(StringUtils.stripToNull((String)key), "key");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        this.buildStatusDao.get(repository.getId(), commitId, key).ifPresent(internalBuildStatus -> {
            Map<String, Commit> commitMap = this.getCommits(repository, null, Collections.singletonList(commitId));
            SimpleBuildStatus toBeDeletedBuildStatus = this.convertBuildStatus(repository, (InternalBuildStatus)internalBuildStatus, commitMap);
            this.buildStatusDao.delete(repository.getId(), commitId, key);
            this.eventPublisher.publish((Object)new RepositoryBuildStatusDeletedEvent((Object)this, (RepositoryBuildStatus)toBeDeletedBuildStatus));
        });
    }

    @Nonnull
    public Page<RepositoryBuildStatus> search(@Nonnull BuildStatusRepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        return this.searchInternal(request, pageRequest).transform(dmzBuildStatus -> dmzBuildStatus);
    }

    @Nonnull
    public Page<RepositoryBuildStatus> search(@Nonnull BuildStatusPullRequestSearchRequest request, @Nonnull PageRequest pageRequest) {
        return this.searchInternal(request, pageRequest).transform(RepositoryBuildStatus.class::cast);
    }

    @Nonnull
    public Page<RepositoryBuildStatus> searchInternal(@Nonnull BuildStatusRepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        this.validateSearchRequest((AbstractBuildStatusSearchRequest)request);
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(500);
        Ref ref = request.getRef();
        if (ref == null && request.getCommitId() == null) {
            ref = this.refService.getDefaultBranch(request.getRepository());
        }
        BuildStatusSearchCriterion criteria = DefaultBuildStatusService.getRepositorySearchCriteria(request, ref);
        List<String> commitIds = request.getCommitId() == null ? Collections.emptyList() : Collections.singletonList(request.getCommitId());
        return this.convertToBuildStatusPage(request.getRepository(), null, pageRequest, this.buildStatusDao.findAll(Collections.singletonList(criteria), commitIds, pageRequest, request.getBuildOrder()));
    }

    @Nonnull
    public Page<RepositoryBuildStatus> searchInternal(@Nonnull BuildStatusPullRequestSearchRequest request, @Nonnull PageRequest pageRequest) {
        Page<InternalBuildStatus> buildStatusPage;
        this.validateSearchRequest((AbstractBuildStatusSearchRequest)request);
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(500);
        Repository repository = request.getRepository();
        Repository fromRepository = request.getPullRequest().isCrossRepository() ? request.getPullRequest().getFromRef().getRepository() : null;
        PullRequest pullRequest = request.getPullRequest();
        List<String> commits = this.extractCommitsFromPullRequest(pullRequest);
        String filterByCommitId = request.getCommitId();
        if (StringUtils.isNotBlank((CharSequence)filterByCommitId) && !commits.contains(filterByCommitId)) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        boolean hasTooManyCommits = (commits = DefaultBuildStatusService.getCommitIdsForFilter(commits, filterByCommitId)).size() > 1000;
        List<String> filterByCommitIds = commits.subList(0, Math.min(commits.size(), 1000));
        ArrayList<BuildStatusSearchCriterion> criteria = new ArrayList<BuildStatusSearchCriterion>();
        PullRequestRef fromRef = pullRequest.getFromRef();
        criteria.add(new BuildStatusSearchCriterion.Builder().ref(fromRef.getId()).repositoryId(repository.getId()).build());
        if (pullRequest.isCrossRepository()) {
            criteria.add(new BuildStatusSearchCriterion.Builder().ref(fromRef.getId()).repositoryId(fromRef.getRepository().getId()).build());
        }
        if (hasTooManyCommits) {
            Predicate<InternalBuildStatus> searchPredicate = internalBuildStatus -> filterByCommitIds.contains(internalBuildStatus.getCommitId());
            buildStatusPage = this.buildStatusDao.findAll(criteria, filterByCommitIds, pageRequest, request.getBuildOrder(), searchPredicate);
        } else {
            buildStatusPage = this.buildStatusDao.findAll(criteria, filterByCommitIds, pageRequest, request.getBuildOrder());
        }
        return this.convertToBuildStatusPage(repository, fromRepository, pageRequest, buildStatusPage);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void set(@Nonnull RepositoryBuildStatusSetRequest request) {
        this.setInternal(request, null);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void setInternal(@Nonnull RepositoryBuildStatusSetRequest request, @Nullable BuildServer buildServer) {
        Objects.requireNonNull(request, "request");
        this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_READ);
        if (this.rejectUntrustedBuildStatus && buildServer == null) {
            throw new UntrustedBuildStatusException(this.i18nService.createKeyedMessage("bitbucket.build.status.untrusted.reject", new Object[0]));
        }
        if (!ShaUtils.isHash((String)request.getCommitId())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.commit.idinvalid", new Object[0]));
        }
        if (!StringUtils.isBlank((CharSequence)request.getRef()) && !request.getRef().startsWith("refs/")) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.operations.error.incorrect.ref.format", new Object[]{request.getRef()}));
        }
        if (!UrlHrefUtils.isSchemeAllowed((String)request.getUrl())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.url.invalid", new Object[0]));
        }
        InternalBuildStatus created = BuildStatusHelper.createWithRetry(this.transactionTemplate, () -> this.buildStatusDao.set(request, buildServer == null ? null : buildServer.getId()));
        SimpleBuildStatus createdBuildStatus = this.convertBuildStatus(request.getRepository(), created, this.getCommits(request.getRepository(), null, Collections.singletonList(request.getCommitId())));
        this.eventPublisher.publish((Object)new AnalyticsBuildStatusSetEvent(this, createdBuildStatus, request.getRepository()));
        this.eventPublisher.publish((Object)new RepositoryBuildStatusSetEvent((Object)this, (RepositoryBuildStatus)createdBuildStatus));
    }

    private static <T> Map<T, BuildSummary> collectSummaries(Map<T, Map<BuildState, Integer>> counts) {
        return ImmutableMap.copyOf((Map)Maps.transformValues(counts, SimpleBuildSummary::new));
    }

    private static List<String> getCommitIdsForFilter(List<String> commitsInPullRequest, String filterByCommitId) {
        if (StringUtils.isNotBlank((CharSequence)filterByCommitId)) {
            return Collections.singletonList(filterByCommitId);
        }
        return commitsInPullRequest;
    }

    private static BuildStatusSearchCriterion getRepositorySearchCriteria(BuildStatusRepositorySearchRequest request, Ref resolvedRef) {
        return new BuildStatusSearchCriterion.Builder().repositoryId(request.getRepository().getId()).ref(resolvedRef != null ? resolvedRef.getId() : null).latestCommitOnRef(resolvedRef != null ? resolvedRef.getLatestCommit() : null).build();
    }

    private static <T> void incrementCount(T id, Map<T, Map<BuildState, Integer>> summaries, BuildCountForRef buildCount) {
        summaries.computeIfAbsent(id, e -> new HashMap<BuildState, Integer>(emptySummary)).put(buildCount.getState(), summaries.get(id).get(buildCount.getState()) + buildCount.getCount());
    }

    private SimpleBuildStatus convertBuildStatus(Repository repository, InternalBuildStatus status, Map<String, Commit> commitMap) {
        SimpleBuildStatus.Builder builder = new SimpleBuildStatus.Builder(status);
        if (status.getRepository() == null) {
            builder.repository(repository);
        }
        if (commitMap.containsKey(status.getCommitId())) {
            builder.commit(commitMap.get(status.getCommitId()));
        }
        this.buildServerService.getPluginBuildServer(status.getBuildServerId()).map(PluginBuildServer::getBuildStatusEnricher).ifPresent(builder::enricher);
        this.buildServerService.getBuildServer(status.getBuildServerId()).ifPresent(builder::buildServer);
        return builder.build();
    }

    private Page<RepositoryBuildStatus> convertToBuildStatusPage(Repository toRepository, Repository fromRepository, PageRequest boundedPageRequest, Page<InternalBuildStatus> page) {
        if (page.getSize() == 0) {
            return PageUtils.createEmptyPage((PageRequest)boundedPageRequest);
        }
        Set<String> commitIds = MoreStreams.streamIterable((Iterable)page.getValues()).map(InternalBuildStatus::getCommitId).collect(Collectors.toSet());
        Map<String, Commit> commitMap = this.getCommits(toRepository, fromRepository, commitIds);
        try (Ticker ignored = Timers.timer((String)String.format("DefaultBuildStatusService: Enriching %s build statuses", page.getSize())).start(new Object[]{toRepository.getId()});){
            Page page2 = page.transform(internalBuildStatus -> this.convertBuildStatus(toRepository, (InternalBuildStatus)internalBuildStatus, commitMap));
            return page2;
        }
    }

    private List<String> extractCommitsFromPullRequest(PullRequest pullRequest) {
        ImmutableList.Builder commitsInPullRequest = new ImmutableList.Builder();
        PullRequestCommitsRequest request = new PullRequestCommitsRequest.Builder(pullRequest).maxMessageLength(0).build();
        this.pullRequestService.streamCommits(request, commit -> {
            commitsInPullRequest.add((Object)commit.getId());
            return true;
        });
        return commitsInPullRequest.build();
    }

    private Map<Ref, BuildSummary> getBuildSummariesForRef(Repository repository, Map<String, Ref> resolvedRefs) {
        try (Ticker ignored = Timers.timer((String)String.format("DefaultBuildStatusService: Getting build summaries for %s refs", resolvedRefs.size())).start(new Object[]{repository.getId()});){
            Map<Ref, BuildSummary> map;
            block12: {
                Collection commitIds = resolvedRefs.values().stream().map(Ref::getLatestCommit).collect(Collectors.toSet());
                ImmutableListMultimap commitToRefMap = Multimaps.index(resolvedRefs.values(), Ref::getLatestCommit);
                BuildStatusBulkRefSummaryCriteria criteria = new BuildStatusBulkRefSummaryCriteria.Builder().commitIds(commitIds).refs(resolvedRefs.values().stream().map(MinimalRef::getId).collect(Collectors.toSet())).repositoryId(repository.getId()).build();
                List<BuildCountForRef> buildCounts = this.buildStatusDao.countByState(criteria);
                Ticker ignored2 = Timers.timer((String)String.format("DefaultBuildStatusService: Post-processing of ref summaries for %s counts", buildCounts.size())).start(new Object[]{repository.getId()});
                try {
                    HashMap summaries = new HashMap();
                    buildCounts.forEach(arg_0 -> DefaultBuildStatusService.lambda$getBuildSummariesForRef$19((Multimap)commitToRefMap, summaries, resolvedRefs, arg_0));
                    map = DefaultBuildStatusService.collectSummaries(summaries);
                    if (ignored2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored2.close();
            }
            return map;
        }
    }

    private Map<String, Commit> getCommits(Repository toRepository, @Nullable Repository fromRepository, Collection<String> commitIds) {
        try (Ticker ignored = Timers.timer((String)String.format("DefaultBuildStatusService: Resolving %s commits", commitIds.size())).start(new Object[]{toRepository.getId(), fromRepository == null ? null : Integer.valueOf(fromRepository.getId())});){
            CommitsCommandParameters commandParameters = new CommitsCommandParameters.Builder().ignoreMissing(true).include(commitIds).secondaryRepository(fromRepository).traverse(false).build();
            HashSet commits = new HashSet();
            this.scmService.getCommandFactory(toRepository).commits(commandParameters, commit -> {
                commits.add(commit);
                return true;
            }).call();
            Map<String, Commit> map = MoreStreams.streamIterable((Iterable)this.commitEnricher.enrichAll(toRepository, commits, Collections.emptySet())).collect(Collectors.toMap(MinimalCommit::getId, commit -> commit));
            return map;
        }
    }

    @Nonnull
    private Map<String, Ref> resolveRefs(@Nonnull Repository repository, @Nonnull Collection<String> refIds) {
        return this.refService.resolveRefs(new ResolveRefsRequest.Builder(repository).refIds(refIds).build());
    }

    private void validateBulkCommitSummaryRequest(AbstractBulkCommitBuildStatusSummaryRequest request) {
        this.validateSummaryRequest((AbstractBuildStatusSummaryRequest)request);
        if (request.getCommitIds().size() > 1000) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.commitlist.toobig", new Object[]{1000}));
        }
    }

    private void validateSearchRequest(AbstractBuildStatusSearchRequest request) {
        Objects.requireNonNull(request);
        this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_READ);
    }

    private void validateSummaryRequest(AbstractBuildStatusSummaryRequest request) {
        Objects.requireNonNull(request);
        this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_READ);
    }

    private static /* synthetic */ void lambda$getBuildSummariesForRef$19(Multimap commitToRefMap, Map summaries, Map resolvedRefs, BuildCountForRef buildCount) {
        Collection refs = commitToRefMap.get((Object)buildCount.getCommitId());
        if (buildCount.getRef() == null) {
            refs.forEach(ref -> DefaultBuildStatusService.incrementCount(ref, summaries, buildCount));
        } else {
            Ref ref2 = (Ref)resolvedRefs.get(buildCount.getRef());
            if (ref2 != null && ref2.getLatestCommit().equals(buildCount.getCommitId())) {
                DefaultBuildStatusService.incrementCount(ref2, summaries, buildCount);
            }
        }
    }

    private static /* synthetic */ void lambda$getSummaries$9(Multimap commitToPullRequest, Map summaries, BuildCountForRef buildCount) {
        Collection pullRequestsAtCommit = commitToPullRequest.get((Object)buildCount.getCommitId());
        if (buildCount.getRef() == null && buildCount.getRepositoryId() == null) {
            pullRequestsAtCommit.forEach(pullRequest -> DefaultBuildStatusService.incrementCount(pullRequest.getId(), summaries, buildCount));
        } else {
            pullRequestsAtCommit.stream().filter(pullRequest -> buildCount.getRef() == null || pullRequest.getFromRef().getId().equals(buildCount.getRef())).filter(pullRequest -> buildCount.getRepositoryId() != null && (pullRequest.getToRef().getRepository().getId() == buildCount.getRepositoryId().intValue() || pullRequest.getFromRef().getRepository().getId() == buildCount.getRepositoryId().intValue())).forEach(pullRequest -> DefaultBuildStatusService.incrementCount(pullRequest.getId(), summaries, buildCount));
        }
    }

    static {
        emptySummary.put(BuildState.CANCELLED, 0);
        emptySummary.put(BuildState.SUCCESSFUL, 0);
        emptySummary.put(BuildState.INPROGRESS, 0);
        emptySummary.put(BuildState.FAILED, 0);
        emptySummary.put(BuildState.UNKNOWN, 0);
    }
}

