/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status;

import com.atlassian.bitbucket.build.BuildOrder;
import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.dmz.build.status.BuildSummary;
import com.atlassian.bitbucket.dmz.build.status.legacy.BuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatus;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatusService;
import com.atlassian.bitbucket.dmz.build.status.legacy.SimpleLegacyBuildStatus;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.status.AnalyticsBuildStatusSetEvent;
import com.atlassian.bitbucket.internal.build.status.BuildStatusHelper;
import com.atlassian.bitbucket.internal.build.status.UntrustedBuildStatusException;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusDao;
import com.atlassian.bitbucket.internal.build.status.model.InternalBuildStatus;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.UrlHrefUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Transactional(readOnly=true)
public class DefaultLegacyBuildStatusService
implements LegacyBuildStatusService {
    private static final int MAX_PAGE_SIZE = 500;
    private static final String PROPERTY_MAX_BUILD_STATUSES = "plugin.bitbucket-build.max.statuses";
    private final BuildStatusDao buildStatusDao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final int maxStatuses;
    private final PermissionValidationService permissionValidationService;
    private final boolean rejectUntrustedBuildStatus;
    private final TransactionTemplate withNewTransaction;

    public DefaultLegacyBuildStatusService(BuildStatusDao buildStatusDao, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, TransactionTemplate transactionTemplate, int maxStatuses, boolean rejectUntrustedBuildStatus) {
        this.buildStatusDao = buildStatusDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.rejectUntrustedBuildStatus = rejectUntrustedBuildStatus;
        this.maxStatuses = maxStatuses;
        this.withNewTransaction = transactionTemplate;
    }

    public DefaultLegacyBuildStatusService(BuildStatusDao buildStatusDao, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, PlatformTransactionManager platformTransactionManager, ApplicationPropertiesService propertiesService, boolean rejectUntrustedBuildStatus) {
        this(buildStatusDao, eventPublisher, i18nService, permissionValidationService, new TransactionTemplate(platformTransactionManager, SpringTransactionUtils.REQUIRES_NEW), propertiesService.getPluginProperty(PROPERTY_MAX_BUILD_STATUSES, 100), rejectUntrustedBuildStatus);
    }

    @Nonnull
    public Page<LegacyBuildStatus> findAll(@Nonnull String commitId) {
        return this.findAll(commitId, PageUtils.newRequest((int)0, (int)this.maxStatuses), BuildOrder.NEWEST);
    }

    @Nonnull
    public Page<LegacyBuildStatus> findAll(@Nonnull String commitId, @Nonnull PageRequest pageRequest, @Nonnull BuildOrder orderBy) {
        this.validateLicensedUser();
        Objects.requireNonNull(commitId, "commitId");
        Objects.requireNonNull(pageRequest, "pageRequest");
        Objects.requireNonNull(orderBy, "orderBy");
        pageRequest = PageUtils.newRequest((int)pageRequest.getStart(), (int)Math.min(pageRequest.getLimit(), 500));
        return this.buildStatusDao.findAll(commitId, pageRequest, orderBy).transform(status -> this.transformBuildStatus((InternalBuildStatus)status));
    }

    @Nonnull
    public Map<String, BuildSummary> getSummaries(@Nonnull Collection<String> commitIds) {
        this.validateLicensedUser();
        if (Objects.requireNonNull(commitIds, "commitIds").isEmpty()) {
            return Collections.emptyMap();
        }
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.buildStatusDao.countByState(commitIds), LegacyBuildSummary::new));
    }

    @Nonnull
    public BuildSummary getSummary(@Nonnull String commitId) {
        this.validateLicensedUser();
        Objects.requireNonNull(commitId, "commitId");
        return new LegacyBuildSummary(this.buildStatusDao.countByState(commitId));
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void set(@Nonnull BuildStatusSetRequest request) {
        this.validateLicensedUser();
        Objects.requireNonNull(request, "request");
        if (this.rejectUntrustedBuildStatus) {
            throw new UntrustedBuildStatusException(this.i18nService.createKeyedMessage("bitbucket.build.status.untrusted.reject", new Object[0]));
        }
        if (!UrlHrefUtils.isSchemeAllowed((String)request.getUrl())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.status.url.invalid", new Object[0]));
        }
        InternalBuildStatus created = BuildStatusHelper.createWithRetry(this.withNewTransaction, () -> this.buildStatusDao.set(request, new Date()));
        LegacyBuildStatus status = this.transformBuildStatus(created);
        this.eventPublisher.publish((Object)new AnalyticsBuildStatusSetEvent((Object)this, status));
    }

    private LegacyBuildStatus transformBuildStatus(InternalBuildStatus status) {
        return new SimpleLegacyBuildStatus.Builder().commitId(status.getCommitId()).dateAdded(status.getUpdatedDate()).description(status.getDescription()).key(status.getKey()).name(status.getName()).state(status.getState()).url(status.getUrl()).build();
    }

    private void validateLicensedUser() {
        this.permissionValidationService.validateForGlobal(Permission.LICENSED_USER);
    }

    private static class LegacyBuildSummary
    implements BuildSummary {
        private final Map<BuildState, Integer> statuses;

        LegacyBuildSummary(Map<BuildState, Integer> statuses) {
            this.statuses = statuses;
        }

        public int getCancelledCount() {
            return this.getCount(BuildState.CANCELLED);
        }

        public int getSuccessfulCount() {
            return this.getCount(BuildState.SUCCESSFUL);
        }

        public int getFailedCount() {
            return this.getCount(BuildState.FAILED);
        }

        public int getInProgressCount() {
            return this.getCount(BuildState.INPROGRESS);
        }

        public int getUnknownCount() {
            return this.getCount(BuildState.UNKNOWN);
        }

        private int getCount(BuildState state) {
            Integer c = this.statuses.get(state);
            return c == null ? 0 : c;
        }
    }
}

