/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.server.BuildStatusEnricher;
import com.atlassian.bitbucket.build.status.BuildServer;
import com.atlassian.bitbucket.build.status.BuildStatusLinks;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.build.status.TestResults;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.dmz.build.status.SimpleTestResults;
import com.atlassian.bitbucket.internal.build.status.SimpleBuildStatusLinks;
import com.atlassian.bitbucket.internal.build.status.model.InternalBuildStatus;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.UrlHrefUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class SimpleBuildStatus
implements RepositoryBuildStatus {
    private final String buildNumber;
    private final BuildServer buildServer;
    private final BuildStatusLinks buildStatusLinks;
    private final Commit commit;
    private final String commitId;
    private final Date createdDate;
    private final String description;
    private final Long duration;
    private final String key;
    private final String name;
    private final String parent;
    private final String ref;
    private final Repository repository;
    private final BuildState state;
    private final TestResults testResults;
    private final Date updatedDate;
    private final String url;

    private SimpleBuildStatus(Builder builder) {
        this.buildNumber = builder.buildNumber;
        this.buildServer = builder.buildServer;
        this.commit = builder.commit;
        this.commitId = Objects.requireNonNull(builder.commitId, "commitId");
        this.createdDate = Objects.requireNonNull(builder.createdDate, "createdDate");
        this.description = builder.description;
        this.duration = builder.duration;
        this.key = Objects.requireNonNull(builder.key, "key");
        this.name = builder.name;
        this.parent = builder.parent;
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.ref = builder.ref;
        this.state = Objects.requireNonNull(builder.state, "state");
        this.testResults = builder.testResults;
        this.updatedDate = Objects.requireNonNull(builder.updatedDate, "updatedDate");
        this.url = UrlHrefUtils.getSanitizedUrl((String)Objects.requireNonNull(builder.url, "url"));
        this.buildStatusLinks = builder.enricher == null ? new SimpleBuildStatusLinks() : new SimpleBuildStatusLinks(builder.enricher.getArtifactLink((RepositoryBuildStatus)this).orElse(null), builder.enricher.getLogLink((RepositoryBuildStatus)this).orElse(null));
    }

    @Nonnull
    public Optional<String> getBuildNumber() {
        return Optional.ofNullable(this.buildNumber);
    }

    @Nonnull
    public Optional<BuildServer> getBuildServer() {
        return Optional.ofNullable(this.buildServer);
    }

    @Nonnull
    public BuildStatusLinks getBuildStatusLinks() {
        return this.buildStatusLinks;
    }

    @Nonnull
    public Optional<Commit> getCommit() {
        return Optional.ofNullable(this.commit);
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Nonnull
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Nonnull
    public Optional<Long> getDuration() {
        return Optional.ofNullable(this.duration);
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Nonnull
    public Optional<String> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Nonnull
    public Optional<String> getRef() {
        return Optional.ofNullable(this.ref);
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public BuildState getState() {
        return this.state;
    }

    @Nonnull
    public Optional<TestResults> getTestResults() {
        return Optional.ofNullable(this.testResults);
    }

    @Nonnull
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "SimpleBuildStatus{buildNumber='" + this.buildNumber + "', buildServer=" + String.valueOf(this.buildServer) + ", commit=" + String.valueOf(this.commit) + ", commitId='" + this.commitId + "', createdDate=" + String.valueOf(this.createdDate) + ", description='" + this.description + "', duration=" + this.duration + ", key='" + this.key + "', name='" + this.name + "', parent='" + this.parent + "', repository='" + String.valueOf(this.repository) + "', ref='" + this.ref + "', state=" + String.valueOf(this.state) + ", testResults=" + String.valueOf(this.testResults) + ", updatedDate=" + String.valueOf(this.updatedDate) + ", url='" + this.url + "'}";
    }

    public static class Builder
    extends BuilderSupport {
        private String buildNumber;
        private BuildServer buildServer;
        private Commit commit;
        private String commitId;
        private Date createdDate;
        private String description;
        private Long duration;
        private BuildStatusEnricher enricher;
        private String key;
        private String name;
        private String parent;
        private String ref;
        private Repository repository;
        private BuildState state;
        private TestResults testResults;
        private Date updatedDate;
        private String url;

        @Nonnull
        public Builder() {
        }

        @Nonnull
        public Builder(@Nonnull InternalBuildStatus internalBuildStatus) {
            Objects.requireNonNull(internalBuildStatus, "internalBuildStatus");
            this.buildNumber = StringUtils.stripToNull((String)internalBuildStatus.getBuildNumber());
            this.commitId = internalBuildStatus.getCommitId();
            this.createdDate = internalBuildStatus.getCreatedDate();
            this.description = StringUtils.stripToNull((String)internalBuildStatus.getDescription());
            this.duration = internalBuildStatus.getDuration();
            this.key = internalBuildStatus.getKey();
            this.name = StringUtils.stripToNull((String)internalBuildStatus.getName());
            this.parent = StringUtils.stripToNull((String)internalBuildStatus.getParent());
            this.repository = internalBuildStatus.getRepository();
            this.ref = StringUtils.stripToNull((String)internalBuildStatus.getRef());
            this.state = internalBuildStatus.getState();
            if (internalBuildStatus.getFailedTests() != null) {
                this.testResults = new SimpleTestResults.Builder().failed(internalBuildStatus.getFailedTests()).skipped(internalBuildStatus.getSkippedTests()).successful(internalBuildStatus.getSuccessfulTests()).build();
            }
            this.updatedDate = internalBuildStatus.getUpdatedDate();
            this.url = internalBuildStatus.getUrl();
        }

        public Builder(@Nonnull RepositoryBuildStatus repositoryBuildStatus) {
            Objects.requireNonNull(repositoryBuildStatus, "repositoryBuildStatus");
            this.buildNumber = repositoryBuildStatus.getBuildNumber().orElse(null);
            this.buildServer = repositoryBuildStatus.getBuildServer().orElse(null);
            this.commit = repositoryBuildStatus.getCommit().orElse(null);
            this.commitId = repositoryBuildStatus.getCommitId();
            this.createdDate = repositoryBuildStatus.getCreatedDate();
            this.description = StringUtils.stripToNull((String)repositoryBuildStatus.getDescription().orElse(null));
            this.duration = repositoryBuildStatus.getDuration().orElse(null);
            this.key = repositoryBuildStatus.getKey();
            this.name = StringUtils.stripToNull((String)repositoryBuildStatus.getName().orElse(null));
            this.parent = repositoryBuildStatus.getParent().orElse(null);
            this.repository = repositoryBuildStatus.getRepository();
            this.ref = StringUtils.stripToNull((String)repositoryBuildStatus.getRef().orElse(null));
            this.state = repositoryBuildStatus.getState();
            this.testResults = repositoryBuildStatus.getTestResults().orElse(null);
            this.updatedDate = repositoryBuildStatus.getUpdatedDate();
            this.url = StringUtils.stripToNull((String)repositoryBuildStatus.getUrl());
        }

        @Nonnull
        public SimpleBuildStatus build() {
            return new SimpleBuildStatus(this);
        }

        @Nonnull
        public Builder buildNumber(@Nullable String buildNumber) {
            this.buildNumber = StringUtils.stripToNull((String)buildNumber);
            return this;
        }

        @Nonnull
        public Builder buildServer(@Nullable BuildServer buildServer) {
            this.buildServer = buildServer;
            return this;
        }

        @Nonnull
        public Builder commit(@Nonnull Commit commit) {
            this.commit = commit;
            return this;
        }

        @Nonnull
        public Builder commitId(@Nonnull String commitId) {
            this.commitId = Builder.requireNonBlank((String)commitId, (String)"commitId");
            return this;
        }

        public Builder createdDate(@Nonnull Date createdDate) {
            this.createdDate = Objects.requireNonNull(createdDate, "createdDate");
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String description) {
            this.description = StringUtils.stripToNull((String)description);
            return this;
        }

        @Nonnull
        public Builder duration(@Nullable Long duration) {
            this.duration = duration;
            return this;
        }

        @Nonnull
        public Builder enricher(@Nullable BuildStatusEnricher enricher) {
            this.enricher = enricher;
            return this;
        }

        @Nonnull
        public Builder key(@Nonnull String key) {
            this.key = StringUtils.stripToNull((String)key);
            return this;
        }

        @Nonnull
        public Builder name(@Nullable String name) {
            this.name = StringUtils.stripToNull((String)name);
            return this;
        }

        @Nonnull
        public Builder parent(@Nullable String parent) {
            this.parent = StringUtils.stripToNull((String)parent);
            return this;
        }

        @Nonnull
        public Builder ref(@Nullable String ref) {
            this.ref = StringUtils.stripToNull((String)ref);
            return this;
        }

        @Nonnull
        public Builder repository(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull BuildState state) {
            this.state = state;
            return this;
        }

        @Nonnull
        public Builder testResults(@Nonnull TestResults testResults) {
            this.testResults = testResults;
            return this;
        }

        @Nonnull
        public Builder updatedDate(@Nonnull Date dateAdded) {
            this.updatedDate = dateAdded;
            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String url) {
            this.url = url;
            return this;
        }
    }
}

