/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status;

import com.atlassian.bitbucket.dmz.build.status.BuildStatusParent;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SimpleBuildStatusParent
implements BuildStatusParent {
    private final String exampleName;
    private final String parent;

    private SimpleBuildStatusParent(Builder builder) {
        this.exampleName = StringUtils.stripToNull((String)builder.exampleName);
        this.parent = builder.parent;
    }

    @Nonnull
    public Optional<String> getExampleName() {
        return Optional.ofNullable(this.exampleName);
    }

    @Nonnull
    public String getParent() {
        return this.parent;
    }

    public static class Builder {
        private String exampleName;
        private final String parent;

        public Builder(@Nonnull String parent) {
            this.parent = Objects.requireNonNull(StringUtils.stripToNull((String)parent), "parent");
        }

        public Builder exampleName(@Nullable String exampleName) {
            this.exampleName = exampleName;
            return this;
        }

        public SimpleBuildStatusParent build() {
            return new SimpleBuildStatusParent(this);
        }
    }
}

