/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status.dao;

import com.atlassian.bitbucket.build.BuildState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class BuildCountForRef {
    private final String commitId;
    private final int count;
    private final String ref;
    private final Integer repositoryId;
    private final BuildState state;

    public BuildCountForRef(@Nonnull String commitId, @Nullable String ref, @Nullable Integer repositoryId, @Nonnull BuildState state, int count) {
        this.commitId = Objects.requireNonNull(commitId, "commitId");
        this.ref = ref;
        this.repositoryId = repositoryId;
        this.state = Objects.requireNonNull(state, "state");
        this.count = count;
    }

    public BuildCountForRef(@Nonnull String commitId, @Nullable String ref, @Nullable Integer repositoryId, @Nonnull String buildStateId, long count) {
        this(commitId, ref, repositoryId, BuildState.valueOf((String)Objects.requireNonNull(buildStateId, "buildStateId")), (int)count);
    }

    public BuildCountForRef(@Nonnull String commitId, @Nonnull BuildState state, int count) {
        this(commitId, null, null, state, count);
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    public int getCount() {
        return this.count;
    }

    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Nullable
    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    @Nonnull
    public BuildState getState() {
        return this.state;
    }
}

