/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status.dao;

import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class BuildStatusBulkCommitSummaryCriteria {
    private final Integer additionalRepositoryId;
    private final Collection<String> commitIds;
    private final String ref;
    private final Integer repositoryId;

    private BuildStatusBulkCommitSummaryCriteria(Builder builder) {
        this.additionalRepositoryId = builder.additionalRepositoryId;
        this.commitIds = builder.commitIds.build();
        this.ref = builder.ref;
        this.repositoryId = builder.repositoryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildStatusBulkCommitSummaryCriteria that = (BuildStatusBulkCommitSummaryCriteria)o;
        return Objects.equals(this.commitIds, that.commitIds) && Objects.equals(this.ref, that.ref) && Objects.equals(this.repositoryId, that.repositoryId);
    }

    @Nullable
    public Integer getAdditionalRepositoryId() {
        return this.additionalRepositoryId;
    }

    @Nonnull
    public Collection<String> getCommitIds() {
        return this.commitIds;
    }

    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Nullable
    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public int hashCode() {
        return Objects.hash(this.commitIds, this.ref, this.repositoryId);
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> commitIds = new ImmutableSet.Builder();
        private Integer additionalRepositoryId;
        private String ref;
        private Integer repositoryId;

        @Nonnull
        public Builder additionalRepositoryId(@Nonnull Integer value) {
            this.additionalRepositoryId = Objects.requireNonNull(value, "additionalRepositoryId");
            return this;
        }

        public BuildStatusBulkCommitSummaryCriteria build() {
            return new BuildStatusBulkCommitSummaryCriteria(this);
        }

        @Nonnull
        public Builder commitId(@Nonnull String value) {
            this.commitIds.add((Object)Objects.requireNonNull(value, "commitId"));
            return this;
        }

        @Nonnull
        public Builder commitIds(@Nonnull Collection<String> values) {
            this.commitIds.addAll((Iterable)Objects.requireNonNull(values, "commitIds"));
            return this;
        }

        @Nonnull
        public Builder ref(@Nullable String value) {
            this.ref = StringUtils.stripToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder repositoryId(@Nullable Integer value) {
            this.repositoryId = value;
            return this;
        }
    }
}

