/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status.dao;

import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;

public class BuildStatusBulkRefSummaryCriteria {
    private final Collection<String> commitIds;
    private final Collection<String> refs;
    private final Collection<Integer> repositoryIds;

    private BuildStatusBulkRefSummaryCriteria(Builder builder) {
        this.commitIds = builder.commitIds.build();
        this.refs = builder.refs.build();
        this.repositoryIds = builder.repositoryIds.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildStatusBulkRefSummaryCriteria that = (BuildStatusBulkRefSummaryCriteria)o;
        return Objects.equals(this.commitIds, that.commitIds) && Objects.equals(this.refs, that.refs) && Objects.equals(this.repositoryIds, that.repositoryIds);
    }

    @Nonnull
    public Collection<String> getCommitIds() {
        return this.commitIds;
    }

    @Nonnull
    public Collection<String> getRefs() {
        return this.refs;
    }

    @Nonnull
    public Collection<Integer> getRepositoryIds() {
        return this.repositoryIds;
    }

    public int hashCode() {
        return Objects.hash(this.commitIds, this.refs, this.repositoryIds);
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> commitIds = new ImmutableSet.Builder();
        private final ImmutableSet.Builder<String> refs = ImmutableSet.builder();
        private final ImmutableSet.Builder<Integer> repositoryIds = ImmutableSet.builder();

        public BuildStatusBulkRefSummaryCriteria build() {
            return new BuildStatusBulkRefSummaryCriteria(this);
        }

        @Nonnull
        public Builder commitId(@Nonnull String value) {
            this.commitIds.add((Object)Objects.requireNonNull(value, "commitId"));
            return this;
        }

        @Nonnull
        public Builder commitIds(@Nonnull Collection<String> values) {
            this.commitIds.addAll((Iterable)Objects.requireNonNull(values, "commitIds"));
            return this;
        }

        @Nonnull
        public Builder refs(@Nonnull Collection<String> values) {
            this.refs.addAll((Iterable)Objects.requireNonNull(values, "refs"));
            return this;
        }

        @Nonnull
        public Builder repositoryId(int repositoryId) {
            this.repositoryIds.add((Object)repositoryId);
            return this;
        }

        @Nonnull
        public Builder repositoryIds(@Nonnull Collection<Integer> values) {
            this.repositoryIds.addAll((Iterable)Objects.requireNonNull(values, "repositoryIds"));
            return this;
        }
    }
}

