/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status.dao;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class BuildStatusSearchCriterion {
    private final String latestCommitOnRef;
    private final String ref;
    private final Integer repositoryId;

    private BuildStatusSearchCriterion(Builder builder) {
        this.latestCommitOnRef = builder.latestCommitOnRef;
        this.ref = builder.ref;
        this.repositoryId = builder.repositoryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildStatusSearchCriterion that = (BuildStatusSearchCriterion)o;
        return Objects.equals(this.latestCommitOnRef, that.latestCommitOnRef) && Objects.equals(this.ref, that.ref) && Objects.equals(this.repositoryId, that.repositoryId);
    }

    @Nullable
    public String getLatestCommitOnRef() {
        return this.latestCommitOnRef;
    }

    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Nullable
    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public int hashCode() {
        return Objects.hash(this.latestCommitOnRef, this.ref, this.repositoryId);
    }

    public static class Builder {
        private String latestCommitOnRef;
        private String ref;
        private Integer repositoryId;

        public BuildStatusSearchCriterion build() {
            return new BuildStatusSearchCriterion(this);
        }

        @Nonnull
        public Builder latestCommitOnRef(@Nullable String value) {
            this.latestCommitOnRef = StringUtils.stripToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder ref(@Nullable String value) {
            this.ref = StringUtils.stripToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder repositoryId(@Nullable Integer value) {
            this.repositoryId = value;
            return this;
        }
    }
}

