/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status.dao;

import com.atlassian.bitbucket.build.BuildOrder;
import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.build.status.BuildStatusParent;
import com.atlassian.bitbucket.dmz.build.status.legacy.BuildStatusSetRequest;
import com.atlassian.bitbucket.internal.build.status.SimpleBuildStatusParent;
import com.atlassian.bitbucket.internal.build.status.dao.BuildCountForRef;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusBulkCommitSummaryCriteria;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusBulkRefSummaryCriteria;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusDao;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusSearchCriterion;
import com.atlassian.bitbucket.internal.build.status.dao.ReqCommitIdsQueryComponent;
import com.atlassian.bitbucket.internal.build.status.model.InternalBuildStatus;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="buildStatusDao")
public class HibernateBuildStatusDao
extends AbstractHibernateDao<Integer, InternalBuildStatus>
implements BuildStatusDao {
    private final int maxEntityCount;

    @Autowired
    public HibernateBuildStatusDao(SessionFactory sessionFactory, int maxEntityCount) {
        super(sessionFactory);
        this.maxEntityCount = maxEntityCount;
    }

    @Override
    @Nonnull
    public Map<BuildState, Integer> countByState(@Nonnull String commitId) {
        String hql = "select state, count(*) from InternalBuildStatus where commitId = :commitId group by state";
        List results = this.session().createQuery(hql, Object[].class).setParameter("commitId", (Object)commitId).list();
        return results.stream().collect(Collectors.toMap(row -> BuildState.valueOf((String)((String)row[0])), row -> ((Number)row[1]).intValue()));
    }

    @Override
    @Nonnull
    public Map<String, Map<BuildState, Integer>> countByState(@Nonnull Collection<String> commitIds) {
        if (commitIds.isEmpty()) {
            return Collections.emptyMap();
        }
        String hql = "select commitId, state, count(*) from InternalBuildStatus where commitId in(:commitIds) group by commitId, state";
        List results = this.session().createQuery(hql, Object[].class).setParameter("commitIds", commitIds).list();
        return HibernateBuildStatusDao.collectCounts(results);
    }

    @Override
    @Nonnull
    public Map<String, Map<BuildState, Integer>> countByState(@Nonnull BuildStatusBulkCommitSummaryCriteria summaryCriterion) {
        HqlQueryBuilder.HqlWhereConditionalQueryComponent ands = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"commitId", summaryCriterion.getCommitIds())});
        if (summaryCriterion.getRepositoryId() != null) {
            HqlQueryBuilder.HqlWhereConditionalQueryComponent repositoryOrs = HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"repository"), HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"repository.id", (Object)summaryCriterion.getRepositoryId())});
            if (summaryCriterion.getAdditionalRepositoryId() != null) {
                repositoryOrs.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"repository.id", (Object)summaryCriterion.getAdditionalRepositoryId())});
            }
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{repositoryOrs})});
        }
        if (summaryCriterion.getRef() != null) {
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"ref", (Object)summaryCriterion.getRef()), HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"ref")})});
        }
        HqlQueryBuilder hqlQueryBuilder = HqlQueryBuilder.selectPropertiesFrom(InternalBuildStatus.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"commitId"), HqlQueryBuilder.property((String)"state"), HqlQueryBuilder.rowCount()}).where((HqlQueryBuilder.HqlWhereQueryComponent)HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{ands})).groupBy(new String[]{"commitId", "state"});
        List rows = hqlQueryBuilder.buildQuery(this.session(), Object[].class).list();
        return HibernateBuildStatusDao.collectCounts(rows);
    }

    @Override
    @Nonnull
    public List<BuildCountForRef> countByState(@Nonnull BuildStatusBulkRefSummaryCriteria summaryCriterion) {
        HqlQueryBuilder.HqlWhereConditionalQueryComponent ands = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[0]);
        if (!summaryCriterion.getRepositoryIds().isEmpty()) {
            HqlQueryBuilder.HqlWhereQueryComponent matchesRepository = summaryCriterion.getRepositoryIds().size() == 1 ? HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"repository.id", (Object)summaryCriterion.getRepositoryIds().iterator().next()) : HqlQueryBuilder.HqlWhereQueryComponent.in((String)"repository.id", summaryCriterion.getRepositoryIds());
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"repository"), matchesRepository})});
        }
        ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"commitId", summaryCriterion.getCommitIds())});
        ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"ref"), HqlQueryBuilder.HqlWhereQueryComponent.in((String)"ref", summaryCriterion.getRefs())})});
        HqlQueryBuilder hqlQueryBuilder = HqlQueryBuilder.selectNewClassFrom(InternalBuildStatus.class, BuildCountForRef.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"commitId"), HqlQueryBuilder.property((String)"ref"), HqlQueryBuilder.property((String)"repository.id"), HqlQueryBuilder.property((String)"state"), HqlQueryBuilder.rowCount()}).where((HqlQueryBuilder.HqlWhereQueryComponent)HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{ands})).groupBy(new String[]{"repository.id", "commitId", "ref", "state"}).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.asc((String)"repository.id").nullsFirst(), HqlQueryBuilder.HqlQueryOrder.asc((String)"ref"), HqlQueryBuilder.HqlQueryOrder.asc((String)"state"), HqlQueryBuilder.HqlQueryOrder.asc((String)"commitId")});
        return hqlQueryBuilder.buildQuery(this.session(), BuildCountForRef.class).list();
    }

    @Override
    public int delete(int repositoryId, @Nonnull String commitId, @Nonnull String key) {
        return this.session().createQuery("delete from InternalBuildStatus where repository.id = :repositoryId and commitId = :commitId and key = :key").setParameter("repositoryId", (Object)repositoryId).setParameter("commitId", (Object)commitId).setParameter("key", (Object)key).executeUpdate();
    }

    @Override
    public int deleteByRepositoryId(int repositoryId) {
        return this.session().createQuery("delete from InternalBuildStatus where repository.id = :repositoryId").setParameter("repositoryId", (Object)repositoryId).executeUpdate();
    }

    @Override
    @Nonnull
    public Page<InternalBuildStatus> findAll(@Nonnull String commitId, @Nonnull PageRequest pageRequest, @Nonnull BuildOrder orderBy) {
        Query query = this.session().createQuery("from InternalBuildStatus where commitId = :commitId order by " + HibernateBuildStatusDao.orderToQuery(orderBy), InternalBuildStatus.class).setParameter("commitId", (Object)commitId);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    @Override
    @Nonnull
    public Page<InternalBuildStatus> findAll(@Nonnull List<BuildStatusSearchCriterion> searchCriteria, @Nonnull List<String> commitIds, @Nonnull PageRequest pageRequest, @Nonnull BuildOrder orderBy) {
        return HibernateUtils.initializePage((Page)this.pageQuery(this.createHibernateQuery(searchCriteria, commitIds, true, orderBy), pageRequest));
    }

    @Override
    @Nonnull
    public Page<InternalBuildStatus> findAll(@Nonnull List<BuildStatusSearchCriterion> searchCriteria, @Nonnull List<String> commitIds, @Nonnull PageRequest pageRequest, @Nonnull BuildOrder orderBy, @Nonnull Predicate<InternalBuildStatus> predicate) {
        return HibernateUtils.initializePage((Page)this.pageQuery(this.createHibernateQuery(searchCriteria, commitIds, false, orderBy), pageRequest, predicate));
    }

    @Override
    @Nonnull
    public Page<BuildStatusParent> findMatchingParents(int repositoryId, @Nonnull String filter, @Nonnull Date earliestCreatedDate, @Nonnull PageRequest pageRequest) {
        String hql = "select parent, min(name) from InternalBuildStatus where repository.id = :repositoryId and lower(parent) like :parent and createdDate >= :date group by parent order by parent";
        Query query = this.session().createQuery(hql).setParameter("repositoryId", (Object)repositoryId).setParameter("parent", (Object)(StringUtils.lowerCase((String)filter) + "%")).setParameter("date", (Object)earliestCreatedDate);
        Page result = HibernatePageUtils.pageQuery((Query)query, (PageRequest)pageRequest);
        return result.transform(queryResult -> new SimpleBuildStatusParent.Builder((String)queryResult[0]).exampleName((String)queryResult[1]).build());
    }

    @Override
    @Nonnull
    public Optional<InternalBuildStatus> get(int repositoryId, @Nonnull String commitId, @Nonnull String key) {
        return this.getInternal(repositoryId, commitId, key);
    }

    @Override
    @Nonnull
    public InternalBuildStatus set(@Nonnull RepositoryBuildStatusSetRequest request, @Nullable String buildServerId) {
        InternalBuildStatus.Builder builder = new InternalBuildStatus.Builder(request).buildServerId(buildServerId);
        return this.setInternal(builder, request.getRepository().getId(), request.getCommitId(), request.getKey());
    }

    @Override
    @Nonnull
    public InternalBuildStatus set(@Nonnull BuildStatusSetRequest request, @Nonnull Date dateAdded) {
        InternalBuildStatus.Builder builder = new InternalBuildStatus.Builder(request).updatedDate(dateAdded);
        return this.setInternal(builder, null, request.getCommitId(), request.getKey());
    }

    private static void addOrderToBuilder(HqlQueryBuilder<?> queryBuilder, BuildOrder orderBy) {
        switch (orderBy) {
            case STATE: {
                queryBuilder.orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.asc((String)"state"), HqlQueryBuilder.HqlQueryOrder.desc((String)"createdDate")});
                return;
            }
            case OLDEST: {
                queryBuilder.orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.asc((String)"createdDate")});
                return;
            }
            case NEWEST: {
                queryBuilder.orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.desc((String)"createdDate")});
                return;
            }
        }
        throw new IllegalArgumentException("Unexpected BuildOrder: " + String.valueOf(orderBy));
    }

    private static Map<String, Map<BuildState, Integer>> collectCounts(List<Object[]> results) {
        HashMap<String, Map<BuildState, Integer>> counts = new HashMap<String, Map<BuildState, Integer>>();
        results.forEach(row -> {
            String commitId = (String)row[0];
            BuildState state = BuildState.valueOf((String)((String)row[1]));
            int count = ((Number)row[2]).intValue();
            counts.computeIfAbsent(commitId, e -> new HashMap()).put(state, count);
        });
        return counts;
    }

    @Nullable
    private static ReqCommitIdsQueryComponent getLegacyBuildStatusWhereComponent(Integer repositoryId, boolean hasCommits, String latestCommitOnRef) {
        ArrayList<Object> andItems = new ArrayList<Object>();
        boolean requireCommitIds = true;
        if (!hasCommits && !StringUtils.isBlank((CharSequence)latestCommitOnRef)) {
            andItems.add(HqlQueryBuilder.HqlWhereQueryComponent.in((String)"commitId", Collections.singleton(latestCommitOnRef)));
            requireCommitIds = false;
        } else if (!hasCommits) {
            return null;
        }
        andItems.add(HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"repository.id", (Object)repositoryId), HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"repository")}));
        andItems.add(HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"ref"));
        return new ReqCommitIdsQueryComponent(requireCommitIds, (HqlQueryBuilder.HqlWhereQueryComponent)HqlQueryBuilder.HqlWhereQueryComponent.and(andItems));
    }

    @Nullable
    private static ReqCommitIdsQueryComponent getModernBuildStatusWhereComponent(@Nullable String ref, boolean hasCommits, boolean commitIdsComplete, @Nullable Integer repositoryId) {
        HqlQueryBuilder.HqlWhereConditionalQueryComponent modernBuildStatusComponents = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[0]);
        if (repositoryId != null) {
            modernBuildStatusComponents.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"repository.id", (Object)repositoryId)});
        }
        if (ref != null) {
            modernBuildStatusComponents.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"ref", (Object)ref)});
        }
        if (modernBuildStatusComponents.isEmpty()) {
            return null;
        }
        HqlQueryBuilder.HqlWhereConditionalQueryComponent and = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{modernBuildStatusComponents});
        boolean requireCommitIds = hasCommits && commitIdsComplete;
        return new ReqCommitIdsQueryComponent(requireCommitIds, (HqlQueryBuilder.HqlWhereQueryComponent)and);
    }

    private static List<ReqCommitIdsQueryComponent> getWhereCriterionForSearch(BuildStatusSearchCriterion searchCriterion, boolean hasCommits, boolean commitIdsComplete) {
        String ref = searchCriterion.getRef();
        Integer repositoryId = searchCriterion.getRepositoryId();
        String latestCommitOnRef = searchCriterion.getLatestCommitOnRef();
        ReqCommitIdsQueryComponent legacyBuildStatusCriteria = HibernateBuildStatusDao.getLegacyBuildStatusWhereComponent(repositoryId, hasCommits, latestCommitOnRef);
        ReqCommitIdsQueryComponent modernBuildStatusCriteria = HibernateBuildStatusDao.getModernBuildStatusWhereComponent(ref, hasCommits, commitIdsComplete, repositoryId);
        return Stream.of(modernBuildStatusCriteria, legacyBuildStatusCriteria).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static String orderToQuery(@Nonnull BuildOrder orderBy) {
        switch (orderBy) {
            case STATE: {
                return "state ASC, createdDate DESC";
            }
            case OLDEST: {
                return "createdDate ASC";
            }
            case NEWEST: {
                return "createdDate DESC";
            }
        }
        throw new IllegalArgumentException("Unexpected BuildOrder: " + String.valueOf(orderBy));
    }

    private Query<InternalBuildStatus> createHibernateQuery(List<BuildStatusSearchCriterion> searchCriteria, @Nonnull List<String> commitIds, boolean commitIdsComplete, BuildOrder orderBy) {
        HqlQueryBuilder hqlQueryBuilder = HqlQueryBuilder.selectFrom(InternalBuildStatus.class);
        HqlQueryBuilder.HqlWhereConditionalQueryComponent orRequiringCommits = HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[0]);
        HqlQueryBuilder.HqlWhereConditionalQueryComponent orNotRequiringCommits = HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[0]);
        for (BuildStatusSearchCriterion searchCriterion : searchCriteria) {
            List<ReqCommitIdsQueryComponent> criterionForSearch = HibernateBuildStatusDao.getWhereCriterionForSearch(searchCriterion, !commitIds.isEmpty(), commitIdsComplete);
            for (ReqCommitIdsQueryComponent crit : criterionForSearch) {
                if (crit.isRequireCommitIds()) {
                    orRequiringCommits.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{crit.getQueryComponent()});
                    continue;
                }
                orNotRequiringCommits.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{crit.getQueryComponent()});
            }
        }
        HqlQueryBuilder.HqlWhereConditionalQueryComponent outer = HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[0]);
        if (!orRequiringCommits.isEmpty()) {
            outer.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{orRequiringCommits, HqlQueryBuilder.HqlWhereQueryComponent.in((String)"commitId", commitIds)})});
        }
        if (!orNotRequiringCommits.isEmpty()) {
            outer.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{orNotRequiringCommits});
        }
        hqlQueryBuilder.where((HqlQueryBuilder.HqlWhereQueryComponent)outer);
        HibernateBuildStatusDao.addOrderToBuilder(hqlQueryBuilder, orderBy);
        return hqlQueryBuilder.buildQuery(this.session());
    }

    private Optional<InternalBuildStatus> getInternal(@Nullable Integer repositoryId, @Nonnull String commitId, @Nonnull String key) {
        HqlQueryBuilder queryBuilder = HqlQueryBuilder.selectFrom(InternalBuildStatus.class);
        HqlQueryBuilder.HqlWhereConditionalQueryComponent andComponents = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"commitId", (Object)commitId), HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"key", (Object)key)});
        if (repositoryId == null) {
            andComponents.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"nonNullRepositoryId", (Object)-1)});
        } else {
            andComponents.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"nonNullRepositoryId", (Object)-1), HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"nonNullRepositoryId", (Object)repositoryId)})});
        }
        queryBuilder.where((HqlQueryBuilder.HqlWhereQueryComponent)andComponents);
        queryBuilder.orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.desc((String)"nonNullRepositoryId")});
        Query query = queryBuilder.buildQuery(this.session());
        query.setMaxResults(1);
        return query.list().stream().findFirst().map(HibernateUtils::initialize);
    }

    private InternalBuildStatus setInternal(@Nonnull InternalBuildStatus.Builder builder, @Nullable Integer repositoryId, @Nonnull String commitId, @Nonnull String key) {
        this.getInternal(repositoryId, commitId, key).ifPresent(builder::previousBuildStatus);
        InternalBuildStatus buildStatus = (InternalBuildStatus)HibernateUtils.initialize((Object)((InternalBuildStatus)this.update(builder.build())));
        if (this.session().getStatistics().getEntityCount() > this.maxEntityCount) {
            this.session().flush();
            this.session().clear();
        }
        return buildStatus;
    }
}

