/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.status.migration;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.build.status.dao.DmzLegacyBuildDao;
import com.atlassian.bitbucket.dmz.build.status.legacy.BuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatus;
import com.atlassian.bitbucket.dmz.upgrade.async.AsyncDatabaseTaskComplete;
import com.atlassian.bitbucket.internal.build.status.dao.BuildStatusDao;
import com.atlassian.bitbucket.internal.build.status.migration.BuildStatusMigrationStateHelper;
import com.atlassian.bitbucket.internal.build.status.migration.BuildStatusMigrationStatusChanged;
import com.atlassian.bitbucket.internal.build.status.migration.MigrationState;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.plugin.OsgiServiceProxyFactory;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class BuildStatusMigrationRunner {
    @VisibleForTesting
    static final String MIGRATION_LOCK_NAME = "buildstatus.migration.lock";
    private static final Logger log = LoggerFactory.getLogger(BuildStatusMigrationRunner.class);
    private final ApplicationPropertyDao applicationPropertyDao;
    private final BuildStatusDao buildStatusDao;
    private final ExecutorService executorService;
    private final DmzLegacyBuildDao legacyBuildDao;
    private final LockService lockService;
    private final Path markerPath;
    private final Topic<BuildStatusMigrationStatusChanged> migrationStateChangedTopic;
    private final ResettableLazyReference<MigrationState> migrationStatus;
    private final TransactionTemplate withNewTransaction;

    public BuildStatusMigrationRunner(ApplicationPropertyDao applicationPropertyDao, BuildStatusDao buildStatusDao, ExecutorService executorService, HomeLayout homeLayout, LockService lockService, TopicService topicService, PlatformTransactionManager transactionManager, OsgiServiceProxyFactory serviceProxyFactory) {
        this(applicationPropertyDao, buildStatusDao, executorService, homeLayout, lockService, topicService, new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW), serviceProxyFactory);
    }

    public BuildStatusMigrationRunner(ApplicationPropertyDao applicationPropertyDao, BuildStatusDao buildStatusDao, ExecutorService executorService, HomeLayout homeLayout, LockService lockService, TopicService topicService, TransactionTemplate transactionTemplate, OsgiServiceProxyFactory serviceProxyFactory) {
        this.applicationPropertyDao = applicationPropertyDao;
        this.buildStatusDao = buildStatusDao;
        this.executorService = executorService;
        this.legacyBuildDao = (DmzLegacyBuildDao)serviceProxyFactory.createProxy(DmzLegacyBuildDao.class);
        this.lockService = lockService;
        this.withNewTransaction = transactionTemplate;
        this.markerPath = BuildStatusMigrationStateHelper.getMarkerPath(homeLayout);
        this.migrationStatus = BuildStatusMigrationStateHelper.getMigrationStatus(this.markerPath);
        this.migrationStateChangedTopic = topicService.getTopic("upgrade:buildstatus.migration.state.changed", TopicSettings.builder(BuildStatusMigrationStatusChanged.class).build());
        topicService.getTopic("upgrade:async.database.complete", TopicSettings.builder(AsyncDatabaseTaskComplete.class).build()).subscribe(message -> this.doJavaMigration((AsyncDatabaseTaskComplete)message.getMessage()));
        this.migrationStateChangedTopic.subscribe(message -> this.migrationStatus.reset());
    }

    private static BuildStatusSetRequest convertOldBuildStatus(LegacyBuildStatus status) {
        return new BuildStatusSetRequest.Builder(status.getCommitId()).description(status.getDescription()).key(status.getKey()).name(status.getName()).state(status.getState()).url(status.getUrl()).build();
    }

    private void doJavaMigration(AsyncDatabaseTaskComplete event) {
        if (this.migrationStatus.get() == MigrationState.DONE || !event.isSuccessful()) {
            return;
        }
        try (LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(MIGRATION_LOCK_NAME));){
            if (guard != null) {
                this.executorService.execute(() -> {
                    if (this.migrationStatus.get() == MigrationState.DONE) {
                        return;
                    }
                    log.info("Starting Java based migration of remaining build statuses");
                    BuildStatusMigrationStateHelper.writeMigrationStateToFile(this.markerPath, MigrationState.STEP2_JAVA_MIGRATION);
                    this.migrationStateChangedTopic.publish((Serializable)new BuildStatusMigrationStatusChanged());
                    this.withNewTransaction.execute(tstatus -> {
                        int endId = this.legacyBuildDao.getMaxId();
                        try {
                            String startString = this.applicationPropertyDao.getById(ApplicationProperty.Key.MAX_AO_BUILD_STATUS_ID).getValue();
                            if (StringUtils.isNotEmpty((CharSequence)startString)) {
                                int startId = Integer.parseInt(startString.trim());
                                PageUtils.toStream(pageRequest -> this.legacyBuildDao.findAllBetween(startId, endId, pageRequest), (int)500).forEach(status -> this.buildStatusDao.set(BuildStatusMigrationRunner.convertOldBuildStatus(status), status.getUpdatedDate()));
                            }
                            this.applicationPropertyDao.deleteById(ApplicationProperty.Key.MAX_AO_BUILD_STATUS_ID);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        BuildStatusMigrationStateHelper.writeMigrationStateToFile(this.markerPath, MigrationState.DONE);
                        return null;
                    });
                    this.migrationStateChangedTopic.publish((Serializable)new BuildStatusMigrationStatusChanged());
                    log.info("Java based build status migration complete");
                });
            }
        }
    }
}

